/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.helper.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class DateUtil {
    public static List<String> getMonthBetween(String minDate, String maxDate) throws ParseException {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(sdf.parse(minDate));
        min.set(min.get(1), min.get(2), 1);
        max.setTime(sdf.parse(maxDate));
        max.set(max.get(1), max.get(2), 2);
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        min = null;
        max = null;
        curr = null;
        return result;
    }

    public static List<String> validatedDateOverlap(List<String> list, String split) {
        return DateUtil.validatedDateOverlap(list, split, "yyyy-MM-dd");
    }

    public static List<String> validatedDateOverlap(List<String> list, String split, String dateFormat) {
        ArrayList<String> errorList = new ArrayList<String>();
        SimpleDateFormat formater = new SimpleDateFormat(dateFormat);
        try {
            for (int i = 0; i < list.size(); ++i) {
                String[] d1 = list.get(i).split(split);
                Date startdate1 = formater.parse(d1[0]);
                Date enddate1 = formater.parse(d1[1]);
                for (int j = i + 1; j < list.size(); ++j) {
                    String[] d2 = list.get(j).split(split);
                    Date startdate2 = formater.parse(d2[0]);
                    Date enddate2 = formater.parse(d2[1]);
                    if (!startdate2.before(startdate1)) {
                        if (startdate2.after(enddate1)) continue;
                        errorList.add(list.get(i) + " \u4e0e " + list.get(j) + " \u91cd\u5408\n");
                        continue;
                    }
                    if (enddate2.before(startdate1)) continue;
                    errorList.add(list.get(i) + " \u4e0e " + list.get(j) + " \u91cd\u5408\n");
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return errorList;
    }

    public static void main(String[] args) throws ParseException {
        DateUtil.testYmd();
    }

    private static void testHs() {
        ArrayList<String> listYmd = new ArrayList<String>();
        listYmd.add("15:00#16:00");
        listYmd.add("12:00#16:00");
        listYmd.add("16:00#17:00");
        List<String> errorList = DateUtil.validatedDateOverlap(listYmd, "#", "HH:mm");
        if (CollectionUtils.isNotEmpty(errorList)) {
            System.out.println(errorList);
        }
    }

    private static void testYmd() {
        ArrayList<String> listYmd = new ArrayList<String>();
        listYmd.add("2011-12-13#2011-12-16");
        listYmd.add("2011-12-14#2011-12-16");
        listYmd.add("2011-12-16#2011-12-30");
        List<String> errorList = DateUtil.validatedDateOverlap(listYmd, "#");
        if (CollectionUtils.isNotEmpty(errorList)) {
            System.out.println(errorList);
        }
    }
}

