/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.helper.util;

import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.helper.enums.RoleEnum;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UserRoleCodeUtil {
    public static String getMjOrBdCode(UserVo user) {
        String roleCode = "";
        if (null == user) {
            return roleCode;
        }
        if (!UserRoleCodeUtil.isLeader(user).booleanValue()) {
            if (user.getRoleCodes().contains(RoleEnum.BD.getCode())) {
                roleCode = UserRoleCodeUtil.getUserNameContainRole(user, RoleEnum.BD.getCode());
            } else if (user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
                roleCode = UserRoleCodeUtil.getUserNameContainRole(user, RoleEnum.MJ.getCode());
            }
        }
        return roleCode;
    }

    public static String isMj(UserVo user) {
        String roleCode = "";
        if (!UserRoleCodeUtil.isLeader(user).booleanValue() && user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
            return UserRoleCodeUtil.getUserNameContainRole(user, RoleEnum.MJ.getCode());
        }
        return roleCode;
    }

    public static String isBd(UserVo user) {
        String roleCode = "";
        if (!UserRoleCodeUtil.isLeader(user).booleanValue() && user.getRoleCodes().contains(RoleEnum.BD.getCode())) {
            return UserRoleCodeUtil.getUserNameContainRole(user, RoleEnum.BD.getCode());
        }
        return roleCode;
    }

    public static String isAe(UserVo user) {
        String roleCode = "";
        if (!UserRoleCodeUtil.isLeader(user).booleanValue() && user.getRoleCodes().contains(RoleEnum.AE.getCode())) {
            return UserRoleCodeUtil.getUserNameContainRole(user, RoleEnum.AE.getCode());
        }
        return roleCode;
    }

    public static String isSale(UserVo user) {
        String roleCode = "";
        if (!UserRoleCodeUtil.isLeader(user).booleanValue() && user.getRoleCodes().contains(RoleEnum.SALE.getCode())) {
            return UserRoleCodeUtil.getUserNameContainRole(user, RoleEnum.SALE.getCode());
        }
        return roleCode;
    }

    public static Boolean isLeader(UserVo user) {
        if (user.getRoleCodes() == null) {
            return false;
        }
        if (user.getRoleCodes().contains(RoleEnum.BDLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.SALELEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.AELEADER.getCode())) {
            return true;
        }
        return false;
    }

    public static String getUserNameContainRole(UserVo userVo, String roleCode) {
        List roleCodes = userVo.getRoleCodes();
        String username = userVo.getUsername();
        if (roleCodes == null) {
            return null;
        }
        if (roleCodes.contains(roleCode)) {
            return StringUtils.isNotEmpty((CharSequence)username) ? username : null;
        }
        return null;
    }
}

