/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.integration.assembly;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.mccms.common.helper.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.mccms.common.helper.autoconfigure.config.AssemblyConfig;
import com.bxm.mccms.common.helper.util.AssemblyUtil;
import com.bxm.mccms.common.integration.assembly.AssemblyDetail;
import com.bxm.mccms.common.integration.assembly.AssemblyList;
import com.bxm.mccms.common.integration.assembly.PageModel;
import com.bxm.mccms.common.integration.assembly.ResultModel;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@EnableConfigurationProperties(value={ApplicationGlobalConfig.class})
public class AssemblyIntegration {
    private static final Logger log = LoggerFactory.getLogger(AssemblyIntegration.class);
    private AssemblyConfig assemblyConfig;
    @Resource
    private RestTemplate restTemplate;

    public AssemblyIntegration(ApplicationGlobalConfig applicationGlobalConfig) {
        this.assemblyConfig = applicationGlobalConfig.getAssembly();
    }

    public ResultModel<PageModel<AssemblyList>> getList(String adId, String pname, Integer pageNum, Integer pageSize) {
        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = AssemblyUtil.getList(this.restTemplate, this.assemblyConfig.getApiUrl(), adId, pname, pageNum, pageSize);
        }
        catch (Exception e) {
            log.error("getList error: adId={}, e={}", (Object)adId, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            return null;
        }
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            ResultModel response = (ResultModel)JSON.parseObject((String)((String)responseEntity.getBody()), (TypeReference)new TypeReference<ResultModel<PageModel<AssemblyList>>>(){}, (Feature[])new Feature[0]);
            return response;
        }
        log.warn("getList httpStatus: ", (Object)httpStatus.value());
        return null;
    }

    public ResultModel<AssemblyDetail> getDetail(String adId, Integer pid) {
        if (StringUtils.isBlank((CharSequence)adId) || null == pid) {
            return null;
        }
        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = AssemblyUtil.getDetail(this.restTemplate, this.assemblyConfig.getApiUrl(), adId, pid);
        }
        catch (Exception e) {
            log.error("getDetail error: adId={}, pid={}, e={}", new Object[]{adId, pid, ExceptionUtils.getFullStackTrace((Throwable)e)});
            return null;
        }
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            ResultModel response = (ResultModel)JSON.parseObject((String)((String)responseEntity.getBody()), (TypeReference)new TypeReference<ResultModel<AssemblyDetail>>(){}, (Feature[])new Feature[0]);
            return response;
        }
        log.warn("getDetail httpStatus: ", (Object)httpStatus.value());
        return null;
    }

    public ResultModel<Boolean> bind(String adId, List<Integer> pids) {
        if (StringUtils.isBlank((CharSequence)adId)) {
            return null;
        }
        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = AssemblyUtil.bind(this.restTemplate, this.assemblyConfig.getApiUrl(), adId, pids);
        }
        catch (Exception e) {
            log.error("bind error: adId={}, pids={}, e={}", new Object[]{adId, StringUtils.join(pids, (String)","), ExceptionUtils.getFullStackTrace((Throwable)e)});
            return null;
        }
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            ResultModel response = (ResultModel)JSON.parseObject((String)((String)responseEntity.getBody()), (TypeReference)new TypeReference<ResultModel<Boolean>>(){}, (Feature[])new Feature[0]);
            return response;
        }
        log.warn("bind httpStatus: ", (Object)httpStatus.value());
        return null;
    }
}

