/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.integration.ssp.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mccms.common.helper.util.PageFactory;
import com.bxm.mccms.common.model.app.AppForItemVO;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.model.app.AppFacadeDTO;
import com.bxm.mcssp.facade.model.app.AppFacadeQueryDTO;
import com.bxm.mcssp.facade.model.app.AppFacadeVO;
import com.bxm.mcssp.facade.model.app.AppWaitingAuditFacadeVO;
import com.bxm.mcssp.facade.service.AppFacadeService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
@EnableFeignClients(value={"com.bxm.mcssp.facade"})
public class AppIntegration {
    private static final Logger log = LoggerFactory.getLogger(AppIntegration.class);
    @Resource
    private AppFacadeService appFacadeService;

    public List<IDAndNameVO> list(String keyword) {
        ResponseEntity resultModel = this.appFacadeService.list(keyword);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (List)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }

    public IPage<AppFacadeVO> page(AppFacadeQueryDTO dto) {
        ResponseEntity resultModel = this.appFacadeService.page(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (IPage)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    public IPage<AppForItemVO> pageForItem(AppFacadeQueryDTO dto) {
        ResponseEntity resultModel = this.appFacadeService.page(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            Page page = new Page();
            BeanUtils.copyProperties((Object)resultModel.getBody(), (Object)page);
            ArrayList records = new ArrayList();
            ((Page)resultModel.getBody()).getRecords().forEach(t -> {
                AppForItemVO item = new AppForItemVO();
                item.setId(t.getId());
                item.setAppId(t.getAppId());
                item.setAppName(t.getAppName());
                item.setPlatformType(t.getPlatformType());
                records.add(item);
            });
            page.setRecords(records);
            return page;
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    public AppFacadeVO get(Long id) {
        ResponseEntity resultModel = this.appFacadeService.get(id);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (AppFacadeVO)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u4fe1\u606f\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return null;
    }

    public Boolean update(AppFacadeDTO dto) {
        ResponseEntity resultModel = this.appFacadeService.update(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u4fee\u6539\u5f00\u53d1\u8005\u4fe1\u606f\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    public IPage<AppWaitingAuditFacadeVO> getAuditPage(String developerKeyword, String appKeyword, String mjCode, Integer status, Long developerId, Integer current, Integer size) {
        ResponseEntity resultModel = this.appFacadeService.getAuditPage(developerKeyword, appKeyword, status, developerId, mjCode, current, size);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (IPage)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u83b7\u53d6\u5a92\u4f53\u5ba1\u6838\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    public Boolean audit(Long id, Boolean auditPass, Boolean mj, String refuseReason, String reviewRefuseIds, String modifyUser) {
        ResponseEntity resultModel = this.appFacadeService.audit(id, auditPass, mj, refuseReason, reviewRefuseIds, modifyUser);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u5ba1\u6838\u5a92\u4f53\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }
}

