/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.integration.ssp.developer;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;
import com.bxm.mcssp.facade.service.DeveloperFacadeService;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
@EnableFeignClients(value={"com.bxm.mcssp.facade"})
public class DeveloperIntegration {
    private static final Logger log = LoggerFactory.getLogger(DeveloperIntegration.class);
    private static final String ERROR_MSG = "\u8c03\u7528app\u670d\u52a1\u67e5\u8be2\u5a92\u4f53\u4fe1\u606f\u5931\u8d25";
    @Resource
    private DeveloperFacadeService developerFacadeService;

    public List<IDAndNameVO> list(String keyword) {
        ResponseEntity resultModel = this.developerFacadeService.list(keyword);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (List)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }

    public IPage<DeveloperFacadeVO> page(DeveloperFacadeQueryDTO dto) {
        ResponseEntity resultModel = this.developerFacadeService.page(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (IPage)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return new Page();
    }

    public DeveloperFacadeVO get(Long id) {
        ResponseEntity resultModel = this.developerFacadeService.get(id);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (DeveloperFacadeVO)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u4fe1\u606f\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return null;
    }

    public Boolean update(DeveloperFacadeDTO dto) {
        ResponseEntity resultModel = this.developerFacadeService.update(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u4fee\u6539\u5f00\u53d1\u8005\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    public List<DeveloperFacadeVO> list(DeveloperFacadeQueryDTO dto) {
        dto.setCurrent(1L);
        dto.setSize(-1L);
        return this.page(dto).getRecords();
    }

    public Boolean setMj(Long developerId, String mjCode, String modifyUser) {
        ResponseEntity resultModel = this.developerFacadeService.setMj(developerId, mjCode, modifyUser);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u7ed9\u5f00\u53d1\u8005\u8bbe\u7f6e\u5a92\u4ecb\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    public Boolean updateBasic(Long developerId, String mjCode, String bdCode, String tags, String modifyUser) {
        ResponseEntity resultModel = this.developerFacadeService.updateBasic(developerId, mjCode, bdCode, tags, modifyUser);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u7ed9\u5f00\u53d1\u8005\u8bbe\u7f6e\u6807\u7b7e.\u5a92\u4ecb.BD\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    public String simulationLogin(Long developerId) {
        ResponseEntity resultModel = this.developerFacadeService.simulationLogin(developerId);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (String)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6a21\u62df\u5f00\u53d1\u8005\u767b\u5f55\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return null;
    }
}

