/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.integration.ssp.position;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.mccms.common.helper.util.PageFactory;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.model.position.PositionAuditFacadeVO;
import com.bxm.mcssp.facade.model.position.PositionFacadeDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;
import com.bxm.mcssp.facade.service.PositionFacadeService;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
@EnableFeignClients(value={"com.bxm.mcssp.facade"})
public class PositionIntegration {
    private static final Logger log = LoggerFactory.getLogger(PositionIntegration.class);
    @Resource
    private PositionFacadeService positionFacadeService;

    public List<IDAndNameVO> list(String keyword) {
        ResponseEntity resultModel = this.positionFacadeService.list(keyword);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (List)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }

    public IPage<PositionFacadeVO> page(PositionFacadeQueryDTO dto) {
        ResponseEntity resultModel = this.positionFacadeService.page(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (IPage)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5e7f\u544a\u4f4d\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    public PositionFacadeVO get(Long id) {
        ResponseEntity resultModel = this.positionFacadeService.get(id);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (PositionFacadeVO)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5f00\u53d1\u8005\u4fe1\u606f\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return null;
    }

    public Boolean update(PositionFacadeDTO dto) {
        ResponseEntity resultModel = this.positionFacadeService.update(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u4fee\u6539\u5f00\u53d1\u8005\u4fe1\u606f\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    public List<PositionFacadeVO> getAllList(PositionFacadeQueryDTO dto) {
        dto.setCurrent(1L);
        dto.setSize(-1L);
        return this.page(dto).getRecords();
    }

    public PositionFacadeVO findByPositionId(String positionId) {
        ResponseEntity resultModel = this.positionFacadeService.findByPositionId(positionId);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (PositionFacadeVO)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636epositionId\u67e5\u8be2\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return null;
    }

    public PositionFacadeVO findAllInfoByPositionId(String positionId) {
        ResponseEntity resultModel = this.positionFacadeService.findAllInfoByPositionId(positionId);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (PositionFacadeVO)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636epositionId\u67e5\u8be2\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return null;
    }

    public List<PositionFacadeVO> findListByPositionIds(List<String> positionIds) {
        if (CollectionUtils.isEmpty(positionIds)) {
            return Collections.emptyList();
        }
        String positionIdsStr = Joiner.on((String)",").skipNulls().join(positionIds);
        ResponseEntity resultModel = this.positionFacadeService.findListByPositionIds(positionIdsStr);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (List)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636epositionIds\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }

    public List<PositionFacadeVO> findByIds(List<Long> positionIds) {
        if (CollectionUtils.isEmpty(positionIds)) {
            return Collections.emptyList();
        }
        String idsStr = Joiner.on((String)",").skipNulls().join(positionIds);
        ResponseEntity resultModel = this.positionFacadeService.findByIds(idsStr);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (List)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636e\u4e3b\u952e\u96c6\u5408\u67e5\u8be2\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }

    public List<String> getAllPositionIds(PositionFacadeQueryDTO dto) {
        ResponseEntity resultModel = this.positionFacadeService.getAllPositionIds(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (List)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6761\u4ef6\u83b7\u53d6\u6240\u6709\u7684\u5e7f\u544a\u4f4dID\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }

    public IPage<PositionAuditFacadeVO> getAuditPage(String developerKeyword, String appKeyword, String positionKeyword, Integer status, Long developerId, String mjCode, Integer current, Integer size) {
        ResponseEntity resultModel = this.positionFacadeService.getAuditPage(developerKeyword, appKeyword, positionKeyword, status, developerId, mjCode, current, size);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (IPage)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5ba1\u6838\u9875\u9762\u5e7f\u544a\u4f4d\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    public List<Long> batchAudit(String idsStr, Boolean auditPass, Boolean mj, String refuseReason, String reviewRefuseIds, String modifyUser) {
        ResponseEntity resultModel = this.positionFacadeService.batchAudit(idsStr, auditPass, mj, refuseReason, reviewRefuseIds, modifyUser);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (List)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6279\u91cf\u5ba1\u6838\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Collections.EMPTY_LIST;
    }

    public Boolean positionSwitch(String positionId, Boolean closedFlag, String modifyUser) {
        ResponseEntity resultModel = this.positionFacadeService.positionSwitch(positionId, closedFlag, modifyUser);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u5f00\u542f/\u5173\u95ed\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }
}

