/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.integration.ssp.position;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.mccms.common.helper.util.PageFactory;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeDTO;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeVO;
import com.bxm.mcssp.facade.service.PositionSdkConfigFacadeService;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
@EnableFeignClients(value={"com.bxm.mcssp.facade"})
public class PositionSdkConfigIntegration {
    private static final Logger log = LoggerFactory.getLogger(PositionSdkConfigIntegration.class);
    @Autowired
    private PositionSdkConfigFacadeService positionSdkConfigFacadeService;

    public Boolean addConfig(PositionSdkConfigFacadeDTO dto) {
        ResponseEntity resultModel = this.positionSdkConfigFacadeService.addConfig(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6dfb\u52a0\u5e7f\u544a\u4f4dSDK\u914d\u7f6e\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    public List<PositionSdkConfigFacadeVO> getConfigList(String positionId) {
        ResponseEntity resultModel = this.positionSdkConfigFacadeService.getConfigList(positionId);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (List)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5e7f\u544a\u4f4dSDK\u914d\u7f6e\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }

    public Boolean syncDefaultPositionSdkConfig(String bxmTypeId) {
        ResponseEntity resultModel = this.positionSdkConfigFacadeService.syncDefaultPositionSdkConfig(bxmTypeId);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u540c\u6b65\u5e7f\u544a\u4f4d\u9ed8\u8ba4\u914d\u7f6e\u6570\u636e\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    public Boolean syncDefaultBackupPositionSdkConfig() {
        ResponseEntity resultModel = this.positionSdkConfigFacadeService.syncDefaultBackupPositionSdkConfig();
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u540c\u6b65\u5e7f\u544a\u4f4d\u9ed8\u8ba4\u515c\u5e95\u914d\u7f6e\u6570\u636e\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    public Boolean pushAllPositionSdkConfig() {
        ResponseEntity resultModel = this.positionSdkConfigFacadeService.pushAllPositionSdkConfig();
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (Boolean)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u540c\u6b65\u5e7f\u544a\u4f4d,\u5e7f\u544a\u4f4dSDK\u914d\u7f6e\u6570\u636e\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Boolean.FALSE;
    }

    public IPage<PositionSdkConfigFacadeVO> page(PositionSdkConfigFacadeQueryDTO dto) {
        ResponseEntity resultModel = this.positionSdkConfigFacadeService.page(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (IPage)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5e7f\u544a\u4f4d\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return PageFactory.noData();
    }

    public List<PositionSdkConfigFacadeVO> getList(PositionSdkConfigFacadeQueryDTO dto) {
        ResponseEntity resultModel = this.positionSdkConfigFacadeService.getList(dto);
        if (HttpStatus.OK.equals((Object)resultModel.getStatusCode())) {
            return (List)resultModel.getBody();
        }
        log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5e7f\u544a\u4f4d\u5217\u8868\u5931\u8d25\uff01-->{}", (Object)resultModel.getStatusCodeValue());
        return Collections.emptyList();
    }
}

