/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.manager.app.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.helper.enums.RoleEnum;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.ssp.app.AppIntegration;
import com.bxm.mccms.common.manager.app.AppService;
import com.bxm.mccms.common.model.app.AppAuditDTO;
import com.bxm.mcssp.common.enums.AuditResultsEnum;
import com.bxm.mcssp.facade.model.app.AppFacadeQueryDTO;
import com.bxm.mcssp.facade.model.app.AppFacadeVO;
import com.bxm.mcssp.facade.model.app.AppWaitingAuditFacadeVO;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class AppServiceImpl
implements AppService {
    private static final Logger log = LoggerFactory.getLogger(AppServiceImpl.class);
    @Autowired
    private AppIntegration appIntegration;

    @Override
    public IPage<AppFacadeVO> page(UserVo user, AppFacadeQueryDTO dto) {
        String mjCode = dto.getMjCode();
        String bdCode = dto.getBdCode();
        if (UserRoleUtil.isMj(user)) {
            if (StringUtils.isNotBlank((CharSequence)mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page();
            }
            mjCode = user.getUsername();
        }
        if (UserRoleUtil.isBd(user)) {
            if (StringUtils.isNotBlank((CharSequence)bdCode) && !bdCode.equals(user.getUsername())) {
                return new Page();
            }
            bdCode = user.getUsername();
        }
        dto.setMjCode(mjCode);
        dto.setBdCode(bdCode);
        dto.setStatus(AuditResultsEnum.PASS.getStatus());
        return this.appIntegration.page(dto);
    }

    @Override
    public IPage<AppWaitingAuditFacadeVO> getAuditPage(UserVo user, String developerKeyword, String appKeyword, String mjCode, Integer status, Long developerId, Integer current, Integer size) {
        Boolean lookAll;
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        if (!(lookAll = Boolean.valueOf(user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()))).booleanValue()) {
            mjCode = user.getUsername();
        }
        return this.appIntegration.getAuditPage(developerKeyword, appKeyword, mjCode, status, developerId, current, size);
    }

    @Override
    public Boolean audit(UserVo user, AppAuditDTO dto) {
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        Boolean mj = user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode()) || user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode());
        Boolean fk = user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        if (!(mj = Boolean.valueOf(mj != false && fk != false ? false : mj)).booleanValue() && !fk.booleanValue()) {
            throw new McCmsException("\u5f53\u524d\u7528\u6237\u89d2\u8272\u5e76\u65e0\u5ba1\u6838\u64cd\u4f5c\u6743\u9650\uff01", new Object[0]);
        }
        return this.appIntegration.audit(dto.getAppId(), dto.getAuditPass(), mj, dto.getRefuseReason(), dto.getReviewRefuseIds(), user.getUsername());
    }
}

