/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.manager.developer.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.service.IPositionDspPosService;
import com.bxm.mccms.common.helper.enums.DspStaticEnum;
import com.bxm.mccms.common.helper.enums.RoleEnum;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.ssp.developer.DeveloperFinanceIntegration;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mccms.common.manager.developer.DeveloperFinanceService;
import com.bxm.mccms.common.model.developer.DeveloperFinanceAuditDTO;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.mcssp.facade.model.developer.DeveloperAssignmentFacadeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFinanceListFacadeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFirstAuditResultFacadeVO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeveloperFinanceServiceImpl
implements DeveloperFinanceService {
    private static final Logger log = LoggerFactory.getLogger(DeveloperFinanceServiceImpl.class);
    @Autowired
    private DeveloperFinanceIntegration developerFinanceIntegration;
    @Autowired
    private PositionIntegration positionIntegration;
    @Autowired
    private IPositionDspPosService positionDspPosService;

    @Override
    public IPage<DeveloperAssignmentFacadeVO> getAssignmentPage(UserVo user, String keyword, Integer financeStatus, Integer appStatus, Integer positionStatus, String mjCode, String bdCode, Boolean isOrderByDateDesc, String code, Integer current, Integer size) {
        IPage<DeveloperAssignmentFacadeVO> auditStatusPage;
        List records;
        Boolean lookAll;
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        if (!(lookAll = Boolean.valueOf(user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()))).booleanValue()) {
            mjCode = user.getUsername();
        }
        if (CollectionUtils.isNotEmpty((Collection)(records = (auditStatusPage = this.developerFinanceIntegration.getAssignmentPage(keyword, financeStatus, appStatus, positionStatus, mjCode, bdCode, isOrderByDateDesc, code, current, size)).getRecords()))) {
            boolean isEditTag = user.getRoleCodes().contains(RoleEnum.PING_TAI_YUN_YING_LEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
            boolean isEdit = user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
            boolean isAudit = user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode()) || user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
            records.stream().forEach(e -> {
                e.setOperatorAudit(isAudit);
                e.setOperatorEdit(isEdit);
                e.setOperatorTag(isEditTag);
            });
        }
        return auditStatusPage;
    }

    @Override
    public IPage<DeveloperFinanceListFacadeVO> getAuditPage(UserVo user, String developerKeyword, String mjCode, long developerId, Integer status, Integer current, Integer size) {
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.emptyList());
        }
        boolean fk = user.getRoleCodes() != null && user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        IPage<DeveloperFinanceListFacadeVO> auditPage = this.developerFinanceIntegration.getAuditPage(developerKeyword, mjCode, developerId, status, current, size);
        if (!fk && auditPage != null && auditPage.getRecords() != null) {
            auditPage.getRecords().stream().forEach(e -> {
                e.setPhoneNum("");
                e.setContacts("");
            });
        }
        return auditPage;
    }

    @Override
    public Boolean audit(UserVo user, DeveloperFinanceAuditDTO dto) {
        boolean isRiskController;
        List roleCodes = user.getRoleCodes();
        if (CollectionUtils.isEmpty((Collection)roleCodes)) {
            throw new McCmsException("\u6682\u65e0\u5ba1\u6838\u6743\u9650", new Object[0]);
        }
        if (roleCodes.contains(RoleEnum.RISK_CONTROL.getCode())) {
            isRiskController = true;
        } else if (roleCodes.contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode()) || roleCodes.contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode())) {
            isRiskController = false;
        } else {
            throw new McCmsException("\u6682\u65e0\u5ba1\u6838\u6743\u9650", new Object[0]);
        }
        boolean result = this.developerFinanceIntegration.audit(isRiskController, dto.getDeveloperId(), dto.getAuditPass(), dto.getRefuseReason(), dto.getReviewRefuseIds(), user.getUsername());
        if (!result) {
            throw new McCmsException("\u5ba1\u6838\u5931\u8d25\uff01", new Object[0]);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean firstAudit(UserVo user, Long developerId, Boolean auditPass) {
        boolean isRiskController;
        List roleCodes = user.getRoleCodes();
        if (CollectionUtils.isEmpty((Collection)roleCodes)) {
            throw new McCmsException("\u6682\u65e0\u5ba1\u6838\u6743\u9650", new Object[0]);
        }
        if (roleCodes.contains(RoleEnum.RISK_CONTROL.getCode())) {
            isRiskController = true;
        } else if (roleCodes.contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode()) || roleCodes.contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode())) {
            isRiskController = false;
        } else {
            throw new McCmsException("\u6682\u65e0\u5ba1\u6838\u6743\u9650", new Object[0]);
        }
        DeveloperFirstAuditResultFacadeVO vo = this.developerFinanceIntegration.firstAudit(developerId, auditPass, user.getUsername(), isRiskController);
        if (vo == null) {
            throw new McCmsException("\u5ba1\u6838\u5931\u8d25\uff01", new Object[0]);
        }
        if (isRiskController && auditPass.booleanValue()) {
            List<PositionFacadeVO> positionFacadeVOList;
            if (CollectionUtils.isNotEmpty((Collection)vo.getPositionSuccessIds()) && CollectionUtils.isNotEmpty(positionFacadeVOList = this.positionIntegration.findByIds(vo.getPositionSuccessIds()))) {
                for (PositionFacadeVO positionFacadeVO : positionFacadeVOList) {
                    PositionSceneTypeEnum positionSceneTypeEnum = PositionSceneTypeEnum.get((Integer)positionFacadeVO.getPositionScene());
                    if (PositionSceneTypeEnum.LOCK_SCREEN != positionSceneTypeEnum) continue;
                    this.positionDspPosService.addDsp(positionFacadeVO.getPositionId(), DspStaticEnum.LOCK_SCREET_DSP, positionFacadeVO.getPositionId());
                }
            }
        } else {
            return vo.getResult() == null ? false : vo.getResult();
        }
        return Boolean.TRUE;
    }
}

