/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.manager.developer.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.helper.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.mccms.common.helper.autoconfigure.config.IPCheckConfig;
import com.bxm.mccms.common.helper.util.HttpUtils;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.ssp.developer.DeveloperIntegration;
import com.bxm.mccms.common.manager.developer.DeveloperService;
import com.bxm.mccms.common.model.developer.DeveloperLastLoginIpVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeveloperServiceImpl
implements DeveloperService {
    private static final Logger log = LoggerFactory.getLogger(DeveloperServiceImpl.class);
    private IPCheckConfig ipCheckConfig;
    @Autowired
    private DeveloperIntegration developerIntegration;

    public DeveloperServiceImpl(ApplicationGlobalConfig globalConfig) {
        this.ipCheckConfig = globalConfig.getIpCheckDeveloper();
    }

    @Override
    public IPage<DeveloperFacadeVO> page(UserVo user, DeveloperFacadeQueryDTO dto) {
        String mjCode = dto.getMjCode();
        String bdCode = dto.getBdCode();
        if (UserRoleUtil.isMj(user)) {
            if (StringUtils.isNotBlank((CharSequence)mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page();
            }
            mjCode = user.getUsername();
        }
        if (UserRoleUtil.isBd(user)) {
            if (StringUtils.isNotBlank((CharSequence)bdCode) && !bdCode.equals(user.getUsername())) {
                return new Page();
            }
            bdCode = user.getUsername();
        }
        dto.setMjCode(mjCode);
        dto.setBdCode(bdCode);
        dto.setReviewFlag(Integer.valueOf(1));
        return this.developerIntegration.page(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DeveloperLastLoginIpVO> getProvideLastLoginIpInfo(Long developerId) {
        CloseableHttpResponse httpResp;
        CloseableHttpClient httpClient;
        block8: {
            List list;
            block7: {
                DeveloperFacadeVO developerFacadeVO = this.developerIntegration.get(developerId);
                String ip = developerFacadeVO.getLastLoginIp();
                if (StringUtils.isBlank((CharSequence)ip)) {
                    return Collections.emptyList();
                }
                String requestUrl = "http://" + this.ipCheckConfig.getIp() + ":" + this.ipCheckConfig.getPort() + "/credit/ads/selectIpAndCheckAppkey?ip=" + ip;
                httpClient = null;
                httpResp = null;
                try {
                    httpClient = HttpUtils.createHttpClient();
                    RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(2000).setSocketTimeout(5000).build();
                    HttpPost httpPost = new HttpPost(requestUrl);
                    httpPost.setConfig(requestConfig);
                    httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    httpResp = httpClient.execute((HttpUriRequest)httpPost);
                    String result = EntityUtils.toString((HttpEntity)httpResp.getEntity());
                    JSONObject jsonObject = JSONObject.parseObject((String)result);
                    if (jsonObject.getBoolean("success").booleanValue()) {
                        List list2;
                        JSONArray data = jsonObject.getJSONArray("data");
                        list = list2 = JSONObject.parseArray((String)data.toJSONString(), DeveloperLastLoginIpVO.class);
                        HttpUtils.close(httpResp);
                        break block7;
                    }
                    HttpUtils.close(httpResp);
                    break block8;
                }
                catch (IOException e) {
                    log.error("\u8bf7\u6c42IP\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    List<DeveloperLastLoginIpVO> list3 = Collections.emptyList();
                    return list3;
                }
            }
            HttpUtils.close(httpClient);
            return list;
        }
        HttpUtils.close(httpClient);
        return Collections.emptyList();
        finally {
            HttpUtils.close(httpResp);
            HttpUtils.close(httpClient);
        }
    }
}

