/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.manager.position.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.datapark.web.model.AssemblyData;
import com.bxm.datapark.web.model.AssemblyDataDTO;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.assembly.AssemblyIntegration;
import com.bxm.mccms.common.integration.assembly.AssemblyList;
import com.bxm.mccms.common.integration.assembly.PageModel;
import com.bxm.mccms.common.integration.assembly.ResultModel;
import com.bxm.mccms.common.integration.datapark.DataparkWebIntegration;
import com.bxm.mccms.common.integration.ssp.position.PositionAssemblyIntegration;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mccms.common.manager.position.PositionAssemblyService;
import com.bxm.mccms.common.model.position.PositionAssemblyDataVO;
import com.bxm.mccms.common.model.position.PositionAssemblyTotalQueryDTO;
import com.bxm.mccms.common.model.position.PositionAssemblyUpdateDTO;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeDTO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionAssemblyFacadeVO;
import com.bxm.mcssp.facade.model.position.PositionFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PositionAssemblyServiceImpl
implements PositionAssemblyService {
    @Autowired
    private PositionIntegration positionIntegration;
    @Autowired
    private PositionAssemblyIntegration positionAssemblyIntegration;
    @Autowired
    private AssemblyIntegration assemblyIntegration;
    @Autowired
    private DataparkWebIntegration dataparkWebIntegration;

    @Override
    public IPage<PositionAssemblyFacadeVO> page(UserVo user, PositionAssemblyFacadeQueryDTO dto) {
        String mjCode = dto.getMjCode();
        if (UserRoleUtil.isMj(user)) {
            if (StringUtils.isNotBlank((CharSequence)mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page();
            }
            mjCode = user.getUsername();
        }
        dto.setMjCode(mjCode);
        return this.positionAssemblyIntegration.page(dto);
    }

    @Override
    public List<IDAndNameVO> assemblyList() {
        Page page = new Page();
        page.setCurrent(1L);
        page.setSize(Integer.MAX_VALUE);
        String positionId = "\u4e00\u4e2a\u65e0\u610f\u4e49\u7684\u5e7f\u544a\u4f4dID";
        IPage<AssemblyList> assemblyPage = this.positionBindAssemblyPage(page, positionId, null);
        ArrayList<IDAndNameVO> resultList = new ArrayList<IDAndNameVO>();
        if (assemblyPage != null && CollectionUtils.isNotEmpty((Collection)assemblyPage.getRecords())) {
            List records = assemblyPage.getRecords();
            for (AssemblyList record : records) {
                IDAndNameVO idAndNameVO = new IDAndNameVO();
                idAndNameVO.setId(Long.valueOf(record.getId()));
                idAndNameVO.setName(record.getName());
                resultList.add(idAndNameVO);
            }
        }
        return resultList;
    }

    @Override
    public IPage<AssemblyList> positionBindAssemblyPage(Page page, String positionId, String pname) {
        ResultModel<PageModel<AssemblyList>> resultModel = this.assemblyIntegration.getList(positionId, pname, Long.valueOf(page.getCurrent()).intValue(), Long.valueOf(page.getSize()).intValue());
        PageModel<AssemblyList> returnValue = resultModel.getReturnValue();
        page.setRecords(returnValue.getList());
        page.setTotal((long)returnValue.getTotal());
        return page;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean update(UserVo user, PositionAssemblyUpdateDTO dto) {
        String[] idArray;
        dto.setModifyTime(LocalDateTime.now());
        dto.setModifyUser(user.getUsername());
        String ids = dto.getPids();
        ArrayList<Integer> idList = null;
        if (StringUtils.isNotBlank((CharSequence)ids) && (idArray = ids.split(",")).length > 0) {
            idList = new ArrayList<Integer>(idArray.length);
            for (String id : idArray) {
                idList.add(Integer.valueOf(id));
            }
        }
        ResultModel<Boolean> bind = this.assemblyIntegration.bind(dto.getPositionId(), idList);
        Boolean result = false;
        if (bind != null && bind.isSuccessed()) {
            result = this.positionAssemblyIntegration.update(dto);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateCloseFlag(UserVo user, PositionAssemblyFacadeDTO dto) {
        dto.setModifyTime(LocalDateTime.now());
        dto.setModifyUser(user.getUsername());
        Boolean result = this.positionAssemblyIntegration.updateCloseFlag(dto);
        return result;
    }

    @Override
    public IPage<PositionAssemblyDataVO> assemblyTotalDataPage(Page page, PositionAssemblyTotalQueryDTO dto) {
        com.bxm.datapark.facade.Page<AssemblyData> assemblyDataPage;
        AssemblyDataDTO search = new AssemblyDataDTO();
        search.setGroup((byte)2);
        search.setStartDate(dto.getStartDate());
        search.setEndDate(dto.getEndDate());
        search.setPageSize(Integer.valueOf(Long.valueOf(page.getSize()).intValue()));
        search.setPageNum(Integer.valueOf(Long.valueOf(page.getCurrent()).intValue()));
        if (StringUtils.isNotBlank((CharSequence)dto.getPositionKeyword())) {
            PositionFacadeQueryDTO positionFacadeQueryDTO = new PositionFacadeQueryDTO();
            positionFacadeQueryDTO.setPositionKeyword(dto.getPositionKeyword());
            List<String> positionIds = this.positionIntegration.getAllPositionIds(positionFacadeQueryDTO);
            if (CollectionUtils.isNotEmpty(positionIds)) {
                search.setPositionIds(positionIds);
            }
        }
        if ((assemblyDataPage = this.dataparkWebIntegration.getAssemblyData(search)) == null) {
            return page;
        }
        List assemblyDataList = assemblyDataPage.getList();
        if (CollectionUtils.isEmpty((Collection)assemblyDataList)) {
            return page;
        }
        AssemblyDataDTO pageDataSearch = new AssemblyDataDTO();
        BeanUtils.copyProperties((Object)search, (Object)pageDataSearch);
        pageDataSearch.setGroup((byte)3);
        pageDataSearch.setPageSize(Integer.valueOf(1));
        pageDataSearch.setPageNum(Integer.valueOf(1));
        com.bxm.datapark.facade.Page<AssemblyData> assemblyPageDataPage = this.dataparkWebIntegration.getAssemblyData(pageDataSearch);
        if (assemblyPageDataPage != null && CollectionUtils.isEmpty((Collection)assemblyDataPage.getList())) {
            assemblyDataPage.getList().addAll(0, assemblyPageDataPage.getList());
        }
        List<String> positionIds = assemblyDataList.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getPositionId())).map(AssemblyData::getPositionId).distinct().collect(Collectors.toList());
        List<PositionFacadeVO> positionList = this.positionIntegration.findListByPositionIds(positionIds);
        Map positionMap = positionList.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        ArrayList<PositionAssemblyDataVO> records = new ArrayList<PositionAssemblyDataVO>();
        for (AssemblyData assemblyData : assemblyDataList) {
            PositionAssemblyDataVO positionAssemblyDataVO = new PositionAssemblyDataVO();
            BeanUtils.copyProperties((Object)assemblyData, (Object)positionAssemblyDataVO);
            positionAssemblyDataVO.setPositionName(positionMap.getOrDefault(assemblyData.getPositionId(), new PositionFacadeVO()).getPositionName());
            records.add(positionAssemblyDataVO);
        }
        page.setRecords(records);
        page.setTotal(assemblyDataPage.getTotal().longValue());
        return page;
    }

    @Override
    public IPage<PositionAssemblyDataVO> assemblyDetailDataPage(Page page, PositionAssemblyTotalQueryDTO dto) {
        AssemblyDataDTO search = new AssemblyDataDTO();
        if (StringUtils.isNotBlank((CharSequence)dto.getPositionId())) {
            ArrayList<String> positionIds = new ArrayList<String>();
            positionIds.add(dto.getPositionId());
            search.setPositionIds(positionIds);
        }
        if (dto.getPid() != null) {
            ArrayList<Integer> pids = new ArrayList<Integer>();
            pids.add(dto.getPid());
            search.setPids(pids);
        }
        search.setStartDate(dto.getStartDate());
        search.setEndDate(dto.getEndDate());
        search.setPageSize(Integer.valueOf(Long.valueOf(page.getSize()).intValue()));
        search.setPageNum(Integer.valueOf(Long.valueOf(page.getCurrent()).intValue()));
        com.bxm.datapark.facade.Page<AssemblyData> assemblyDataPage = this.dataparkWebIntegration.getAssemblyData(search);
        List assemblyDataList = assemblyDataPage.getList();
        if (assemblyDataPage == null || CollectionUtils.isEmpty((Collection)assemblyDataList)) {
            return page;
        }
        ArrayList<PositionAssemblyDataVO> records = new ArrayList<PositionAssemblyDataVO>();
        for (AssemblyData assemblyData : assemblyDataList) {
            PositionAssemblyDataVO positionAssemblyDataVO = new PositionAssemblyDataVO();
            BeanUtils.copyProperties((Object)assemblyData, (Object)positionAssemblyDataVO);
            records.add(positionAssemblyDataVO);
        }
        page.setRecords(records);
        page.setTotal(assemblyDataPage.getTotal().longValue());
        return page;
    }
}

