/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.manager.position.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.PositionCalcConfig;
import com.bxm.mccms.common.core.entity.PositionShieldStrategyRef;
import com.bxm.mccms.common.core.service.IPositionCalcConfigService;
import com.bxm.mccms.common.core.service.IPositionDspPosService;
import com.bxm.mccms.common.core.service.IPositionShieldStrategyRefService;
import com.bxm.mccms.common.helper.enums.DspStaticEnum;
import com.bxm.mccms.common.helper.enums.RoleEnum;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.helper.util.PageFactory;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mccms.common.manager.position.PositionService;
import com.bxm.mccms.common.model.position.PositionAuditDTO;
import com.bxm.mccms.common.model.position.PositionFlowDTO;
import com.bxm.mccms.common.model.position.PositionFlowVO;
import com.bxm.mcssp.common.enums.AuditResultsEnum;
import com.bxm.mcssp.common.enums.position.CustomPositionTypeEnum;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.mcssp.facade.model.position.PositionAuditFacadeVO;
import com.bxm.mcssp.facade.model.position.PositionFacadeDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PositionServiceImpl
implements PositionService {
    @Autowired
    private PositionIntegration positionIntegration;
    @Autowired
    private IPositionCalcConfigService positionCalcConfigService;
    @Autowired
    private IPositionShieldStrategyRefService positionShieldStrategyRefService;
    @Autowired
    private IPositionDspPosService positionDspPosService;

    @Override
    public IPage<PositionFacadeVO> page(UserVo user, PositionFacadeQueryDTO dto) {
        String mjCode = dto.getMjCode();
        String bdCode = dto.getBdCode();
        if (UserRoleUtil.isMj(user)) {
            if (StringUtils.isNotBlank((CharSequence)mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page();
            }
            mjCode = user.getUsername();
        }
        if (UserRoleUtil.isBd(user)) {
            if (StringUtils.isNotBlank((CharSequence)bdCode) && !bdCode.equals(user.getUsername())) {
                return new Page();
            }
            bdCode = user.getUsername();
        }
        dto.setMjCode(mjCode);
        dto.setBdCode(bdCode);
        dto.setStatus(AuditResultsEnum.PASS.getStatus());
        if (dto.getPositionScene() == null) {
            dto.setPositionScenes(PositionSceneTypeEnum.getTypeListByCustomPositionTypeEnum((CustomPositionTypeEnum)CustomPositionTypeEnum.get((Integer)dto.getCustomPositionType())));
        }
        return this.positionIntegration.page(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean update(UserVo user, PositionFacadeDTO dto) {
        dto.setModifyUser(user.getUsername());
        Boolean result = this.positionIntegration.update(dto);
        if (result.booleanValue()) {
            String[] shieldStrategyIdArray;
            PositionFacadeVO positionFacadeVO = this.positionIntegration.get(dto.getId());
            this.addPositionCalcConfig(user, positionFacadeVO);
            QueryWrapper positionShieldStrategyRefWrapper = new QueryWrapper();
            positionShieldStrategyRefWrapper.eq((Object)"position_id", (Object)positionFacadeVO.getPositionId());
            this.positionShieldStrategyRefService.remove((Wrapper)positionShieldStrategyRefWrapper);
            String shieldStrategyIds = dto.getShieldStrategyIds();
            if (StringUtils.isNotBlank((CharSequence)shieldStrategyIds) && (shieldStrategyIdArray = shieldStrategyIds.split(",")).length > 0) {
                ArrayList<PositionShieldStrategyRef> addList = new ArrayList<PositionShieldStrategyRef>(shieldStrategyIdArray.length);
                for (String shieldStrategyId : shieldStrategyIdArray) {
                    PositionShieldStrategyRef ref = new PositionShieldStrategyRef();
                    ref.setPositionId(positionFacadeVO.getPositionId());
                    ref.setShieldStrategyId(Long.valueOf(shieldStrategyId));
                    addList.add(ref);
                }
                this.positionShieldStrategyRefService.saveBatch(addList, 20);
            }
        }
        return result;
    }

    private void addPositionCalcConfig(UserVo user, PositionFacadeVO positionFacadeVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"position_id", (Object)positionFacadeVO.getPositionId());
        PositionCalcConfig positionCalcConfig = (PositionCalcConfig)this.positionCalcConfigService.getOne((Wrapper)queryWrapper);
        if (null == positionCalcConfig) {
            positionCalcConfig = new PositionCalcConfig();
            Date modifyTime = new Date();
            positionCalcConfig.setPositionId(positionFacadeVO.getPositionId());
            positionCalcConfig.setCooperationType(positionFacadeVO.getCooperationType());
            positionCalcConfig.setDivideInto(positionFacadeVO.getDivideInto());
            positionCalcConfig.setBiddingType(positionFacadeVO.getBiddingType());
            positionCalcConfig.setBasePrice(positionFacadeVO.getBasePrice());
            positionCalcConfig.setStartDate(positionFacadeVO.getStartDate());
            positionCalcConfig.setEndDate(positionFacadeVO.getEndDate());
            positionCalcConfig.setOldCooperationType(positionCalcConfig.getCooperationType());
            positionCalcConfig.setOldDivideInto(positionCalcConfig.getDivideInto());
            positionCalcConfig.setOldBiddingType(positionCalcConfig.getBiddingType());
            positionCalcConfig.setOldBasePrice(positionCalcConfig.getBasePrice());
            positionCalcConfig.setOldStartDate(positionCalcConfig.getStartDate());
            positionCalcConfig.setOldEndDate(positionCalcConfig.getEndDate());
            positionCalcConfig.setCreateUser(user.getUsername());
            positionCalcConfig.setCreateTime(modifyTime);
            this.positionCalcConfigService.save(positionCalcConfig);
        }
    }

    @Override
    public IPage<PositionAuditFacadeVO> getAuditPage(UserVo user, String developerKeyword, String appKeyword, String positionKeyword, Integer status, Long developerId, String mjCode, Integer current, Integer size) {
        Boolean lookAll;
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        if (!(lookAll = Boolean.valueOf(user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()))).booleanValue()) {
            mjCode = user.getUsername();
        }
        return this.positionIntegration.getAuditPage(developerKeyword, appKeyword, positionKeyword, status, developerId, mjCode, current, size);
    }

    @Override
    public Boolean batchAudit(UserVo user, PositionAuditDTO dto) {
        boolean auditPass;
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.emptyList());
        }
        Boolean mj = user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode()) || user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode());
        Boolean fk = user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        if (!(mj = Boolean.valueOf(mj != false && fk != false ? false : mj)).booleanValue() && !fk.booleanValue()) {
            throw new McCmsException("\u5f53\u524d\u7528\u6237\u89d2\u8272\u5e76\u65e0\u5ba1\u6838\u64cd\u4f5c\u6743\u9650\uff01", new Object[0]);
        }
        String idsStr = Joiner.on((String)",").skipNulls().join(dto.getIds());
        List<Long> successIds = this.positionIntegration.batchAudit(idsStr, auditPass = AuditResultsEnum.PASS.getStatus().equals(dto.getState()), mj, dto.getRefuseReason(), dto.getReviewRefuseIds(), user.getUsername());
        if (successIds == null || successIds.size() == 0) {
            throw new McCmsException("\u5ba1\u6838\u5931\u8d25\uff01\u8bf7\u786e\u8ba4\u9009\u62e9\u7684\u5e7f\u544a\u4f4d\u6240\u5728\u7684\u5a92\u4f53\u548c\u5f00\u53d1\u8005\u8d22\u52a1\u4fe1\u606f\u662f\u5426\u901a\u8fc7\u5ba1\u6838\u3002", new Object[0]);
        }
        if (fk.booleanValue() && auditPass) {
            for (Long id : successIds) {
                PositionFacadeVO positionFacadeVO = this.positionIntegration.get(id);
                this.addPositionCalcConfig(user, positionFacadeVO);
                PositionSceneTypeEnum positionSceneTypeEnum = PositionSceneTypeEnum.get((Integer)positionFacadeVO.getPositionScene());
                if (PositionSceneTypeEnum.LOCK_SCREEN != positionSceneTypeEnum) continue;
                this.positionDspPosService.addDsp(positionFacadeVO.getPositionId(), DspStaticEnum.LOCK_SCREET_DSP, positionFacadeVO.getPositionId());
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public IPage<PositionFlowVO> pageForFlow(Page page, PositionFlowDTO dto) {
        PositionFacadeQueryDTO query = new PositionFacadeQueryDTO();
        query.setAppId(dto.getAppId());
        query.setPositionKeyword(dto.getPositionName());
        query.setStatus(AuditResultsEnum.PASS.getStatus());
        query.setCurrent(page.getCurrent());
        query.setSize(page.getSize());
        query.setOrders(page.orders());
        IPage<PositionFacadeVO> voPage = this.positionIntegration.page(query);
        List vos = voPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return PageFactory.noData();
        }
        ArrayList records = Lists.newArrayListWithCapacity((int)vos.size());
        for (PositionFacadeVO vo : vos) {
            PositionFlowVO record = new PositionFlowVO();
            record.setId(vo.getId());
            record.setPositionId(vo.getPositionId());
            record.setPositionName(vo.getPositionName());
            record.setAppName(vo.getAppName());
            record.setMonetizedType(vo.getMonetizedType());
            record.setPositionType(vo.getPositionType());
            record.setPositionScene(vo.getPositionScene());
            record.setPositionSize(vo.getPositionSize());
            record.setDeveloperType(vo.getDeveloperType());
            record.setMjName(vo.getMjName());
            record.setClosedFlag(vo.getClosedFlag());
            records.add(record);
        }
        Page resp = new Page(voPage.getCurrent(), voPage.getSize(), voPage.getTotal());
        resp.setRecords((List)records);
        return resp;
    }

    @Override
    public boolean updateFlow(String positionId, Integer closedFlag, String username) {
        this.positionIntegration.positionSwitch(positionId, Objects.equals(closedFlag, 1), username);
        return Boolean.TRUE;
    }

    @Override
    public BigDecimal getBasePrice(String positionId) {
        PositionFacadeVO vo = this.positionIntegration.findByPositionId(positionId);
        if (null == vo) {
            return null;
        }
        return vo.getBasePrice();
    }

    @Override
    public List<PositionFacadeVO> listForSceneDsp(String positionId, Integer positionScene, Integer informationFlowTemplate) {
        PositionFacadeVO positionFacadeVO = this.positionIntegration.findByPositionId(positionId);
        if (positionFacadeVO == null) {
            return Collections.emptyList();
        }
        PositionFacadeQueryDTO positionFacadeQueryDTO = new PositionFacadeQueryDTO();
        positionFacadeQueryDTO.setAppId(positionFacadeVO.getAppId());
        positionFacadeQueryDTO.setStatus(AuditResultsEnum.PASS.getStatus());
        positionFacadeQueryDTO.setPositionScene(positionScene);
        positionFacadeQueryDTO.setInformationFlowTemplate(informationFlowTemplate);
        positionFacadeQueryDTO.setNotInIds(Arrays.asList(positionFacadeVO.getId().intValue()));
        return this.positionIntegration.getAllList(positionFacadeQueryDTO);
    }
}

