/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.pushable;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.mccms.common.core.entity.DspCreative;
import com.bxm.mccms.common.core.entity.PositionDspCreative;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.model.pushable.CreativeCacheVO;
import com.bxm.mccms.facade.model.pushable.CreativePositionRefCacheVO;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreativePushable {
    private static final Logger log = LoggerFactory.getLogger(CreativePushable.class);
    @Autowired
    private CachePushableIntegration cachePushableIntegration;

    public void push(DspCreative t) {
        HashedMap parameters = new HashedMap();
        parameters.put("type", 1);
        try {
            this.cachePushableIntegration.push(CachePushableServiceEnum.CREATIVE, JSONArray.toJSONBytes((Object)this.of(t), (SerializerFeature[])new SerializerFeature[0]), (Map<String, Object>)parameters);
        }
        catch (Exception e) {
            log.error("push error: t={},e={}", (Object)t, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new McCmsException("\u6d88\u606f\u63a8\u9001\u5931\u8d25", new Object[0]);
        }
    }

    public void push(PositionDspCreative t) {
        HashedMap parameters = new HashedMap();
        parameters.put("type", 2);
        try {
            this.cachePushableIntegration.push(CachePushableServiceEnum.CREATIVE, JSONArray.toJSONBytes((Object)this.of(t), (SerializerFeature[])new SerializerFeature[0]), (Map<String, Object>)parameters);
        }
        catch (Exception e) {
            log.error("push error: t={},e={}", (Object)t, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new McCmsException("\u6d88\u606f\u63a8\u9001\u5931\u8d25", new Object[0]);
        }
    }

    private CreativeCacheVO of(DspCreative t) {
        CreativeCacheVO vo = new CreativeCacheVO();
        vo.setId(t.getId());
        vo.setDspId(t.getDspId());
        vo.setDspCrtid(t.getDspCrtid());
        vo.setDspAdvtid(t.getDspAdvtid());
        vo.setAuditStatus(Byte.valueOf(t.getAuditStatus().byteValue()));
        vo.setType(Byte.valueOf(t.getType().byteValue()));
        return vo;
    }

    private CreativePositionRefCacheVO of(PositionDspCreative t) {
        CreativePositionRefCacheVO vo = new CreativePositionRefCacheVO();
        vo.setId(t.getId());
        vo.setPositionId(t.getPositionId());
        vo.setCreativeId(t.getCreativeId());
        vo.setAuditStatus(Byte.valueOf(t.getAuditStatus().byteValue()));
        return vo;
    }
}

