/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.pushable;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.mccms.common.core.entity.SceneActivity;
import com.bxm.mccms.common.core.entity.SceneDspEntranceCreative;
import com.bxm.mccms.common.core.entity.SceneSetting;
import com.bxm.mccms.common.core.service.ISceneActivityService;
import com.bxm.mccms.common.core.service.ISceneDspEntranceCreativeService;
import com.bxm.mccms.common.core.service.ISceneSettingService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.constant.pushable.CachePushableTopicEnum;
import com.bxm.mccms.facade.model.pushable.SceneSettingCacheVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PositionSceneSettingPushable {
    private static final Logger log = LoggerFactory.getLogger(PositionSceneSettingPushable.class);
    @Autowired
    private CachePushableIntegration cachePushableIntegration;
    @Autowired
    private ISceneSettingService sceneSettingService;
    @Autowired
    private ISceneDspEntranceCreativeService sceneDspEntranceCreativeService;
    @Autowired
    private ISceneActivityService sceneActivityService;

    public void push(String positionId) {
        HashedMap parameters = new HashedMap();
        parameters.put("positionId", positionId);
        try {
            this.cachePushableIntegration.push(CachePushableServiceEnum.SCENE_SETTING, JSONArray.toJSONBytes((Object)this.of(positionId), (SerializerFeature[])new SerializerFeature[0]), (Map<String, Object>)parameters, CachePushableTopicEnum.DEFAULT);
        }
        catch (Exception e) {
            log.error("push error: positionId={},e={}", (Object)positionId, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new McCmsException("\u6d88\u606f\u63a8\u9001\u5931\u8d25", new Object[0]);
        }
    }

    private SceneSettingCacheVO of(String positionId) throws Exception {
        List sceneActivityList;
        SceneSettingCacheVO vo = new SceneSettingCacheVO();
        SceneSetting sceneSetting = (SceneSetting)this.sceneSettingService.findOneByOneParamWithNotNull("position_id", positionId);
        BeanUtils.copyProperties((Object)sceneSetting, (Object)vo);
        List sceneDspEntranceCreativeList = this.sceneDspEntranceCreativeService.findListByOneParam("position_id", positionId);
        if (CollectionUtils.isNotEmpty(sceneDspEntranceCreativeList)) {
            ArrayList<SceneSettingCacheVO.MediaEntranceCreative> mediaEntranceCreatives = new ArrayList<SceneSettingCacheVO.MediaEntranceCreative>(sceneDspEntranceCreativeList.size());
            for (SceneDspEntranceCreative sceneDspEntranceCreative : sceneDspEntranceCreativeList) {
                SceneSettingCacheVO.MediaEntranceCreative mediaEntranceCreative = new SceneSettingCacheVO.MediaEntranceCreative();
                BeanUtils.copyProperties((Object)sceneDspEntranceCreative, (Object)mediaEntranceCreative);
                mediaEntranceCreative.setCreativeId(sceneDspEntranceCreative.getId());
                mediaEntranceCreatives.add(mediaEntranceCreative);
            }
            vo.setMediaEntranceCreatives(mediaEntranceCreatives);
        }
        if (CollectionUtils.isNotEmpty(sceneActivityList = this.sceneActivityService.findListByOneParam("position_id", positionId))) {
            ArrayList<SceneSettingCacheVO.SceneActivity> sceneActivities = new ArrayList<SceneSettingCacheVO.SceneActivity>(sceneActivityList.size());
            for (SceneActivity sceneDspEntranceCreative : sceneActivityList) {
                SceneSettingCacheVO.SceneActivity sceneActivity = new SceneSettingCacheVO.SceneActivity();
                BeanUtils.copyProperties((Object)sceneDspEntranceCreative, (Object)sceneActivity);
                sceneActivities.add(sceneActivity);
            }
            vo.setSceneActivities(sceneActivities);
        }
        return vo;
    }
}

