/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.pushable;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.mccms.common.core.entity.ShieldStrategy;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.model.pushable.ShieldStrategyCacheVO;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShieldStrategyPushable {
    private static final Logger log = LoggerFactory.getLogger(ShieldStrategyPushable.class);
    @Autowired
    private CachePushableIntegration cachePushableIntegration;

    public void push(ShieldStrategy t) {
        HashedMap parameters = new HashedMap();
        parameters.put("shieldStrategyId", t.getId());
        try {
            this.cachePushableIntegration.push(CachePushableServiceEnum.SHIELD_STRATEGY, JSONArray.toJSONBytes((Object)this.of(t), (SerializerFeature[])new SerializerFeature[0]), (Map<String, Object>)parameters);
        }
        catch (Exception e) {
            log.error("push error: t={},e={}", (Object)t, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new McCmsException("\u6d88\u606f\u63a8\u9001\u5931\u8d25", new Object[0]);
        }
    }

    public void delete(Serializable id) {
        HashedMap parameters = new HashedMap();
        parameters.put("shieldStrategyId", id);
        try {
            this.cachePushableIntegration.push(CachePushableServiceEnum.SHIELD_STRATEGY, null, (Map<String, Object>)parameters);
        }
        catch (Exception e) {
            log.error("push error: t={},e={}", (Object)id, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new McCmsException("\u6d88\u606f\u63a8\u9001\u5931\u8d25", new Object[0]);
        }
    }

    private ShieldStrategyCacheVO of(ShieldStrategy t) {
        ShieldStrategyCacheVO vo = new ShieldStrategyCacheVO();
        vo.setId(t.getId());
        vo.setStrategyName(t.getStrategyName());
        vo.setShieldKeyword(t.getShieldKeyword());
        vo.setAndroidPackageName(t.getAndroidPackageName());
        vo.setIosId(t.getIosId());
        return vo;
    }
}

