/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.pushable;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.adx.facade.rule.task.Rule;
import com.bxm.adx.facade.rule.task.TaskOfRules;
import com.bxm.mccms.common.core.entity.Task;
import com.bxm.mccms.common.core.entity.TaskRules;
import com.bxm.mccms.common.core.service.ITaskRulesService;
import com.bxm.mccms.common.core.service.ITaskService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.constant.pushable.CachePushableTopicEnum;
import com.bxm.mccms.facade.enums.RuleTypeEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskPushable {
    private static final Logger log = LoggerFactory.getLogger(TaskPushable.class);
    @Autowired
    private CachePushableIntegration cachePushableIntegration;
    @Autowired
    private ITaskService taskService;
    @Autowired
    private ITaskRulesService taskRulesService;

    public void push(Long taskId) {
        HashedMap parameters = new HashedMap();
        parameters.put("taskId", taskId);
        try {
            this.cachePushableIntegration.push(CachePushableServiceEnum.TASK, JSONArray.toJSONBytes((Object)this.of(taskId), (SerializerFeature[])new SerializerFeature[0]), (Map<String, Object>)parameters, CachePushableTopicEnum.ADX_SERVICE_CACHE_PUSH);
        }
        catch (Exception e) {
            log.error("push error: taskId={},e={}", (Object)taskId, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new McCmsException("\u6d88\u606f\u63a8\u9001\u5931\u8d25", new Object[0]);
        }
    }

    private TaskOfRules of(Long taskId) {
        Task task = (Task)this.taskService.getById(taskId);
        TaskOfRules vo = new TaskOfRules();
        BeanUtils.copyProperties((Object)task, (Object)vo);
        QueryWrapper taskQueryWrapper = new QueryWrapper();
        taskQueryWrapper.eq((Object)"task_id", (Object)task.getId());
        List taskRules = this.taskRulesService.list((Wrapper)taskQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)taskRules)) {
            for (TaskRules taskRule : taskRules) {
                RuleTypeEnum ruleTypeEnum = RuleTypeEnum.get((int)taskRule.getRuleType());
                if (ruleTypeEnum == null) continue;
                switch (ruleTypeEnum) {
                    case REGION: {
                        Rule rule = new Rule();
                        BeanUtils.copyProperties((Object)taskRule, (Object)rule);
                        vo.setRegion(rule);
                        break;
                    }
                    case POSITION: {
                        Rule position = new Rule();
                        BeanUtils.copyProperties((Object)taskRule, (Object)position);
                        vo.setPosition(position);
                        break;
                    }
                    case FREQUENCYS: {
                        Rule frequencys = new Rule();
                        BeanUtils.copyProperties((Object)taskRule, (Object)frequencys);
                        vo.setFrequencys(frequencys);
                        break;
                    }
                    case APP: {
                        Rule app = new Rule();
                        BeanUtils.copyProperties((Object)taskRule, (Object)app);
                        vo.setApps(app);
                        break;
                    }
                    case DEVICE_BRAND: {
                        Rule deviceBrand = new Rule();
                        BeanUtils.copyProperties((Object)taskRule, (Object)deviceBrand);
                        vo.setDeviceBrands(deviceBrand);
                        break;
                    }
                    case TIME_SLOT: {
                        Rule timeSlot = new Rule();
                        BeanUtils.copyProperties((Object)taskRule, (Object)timeSlot);
                        vo.setTimeSlots(timeSlot);
                        break;
                    }
                }
            }
        }
        return vo;
    }
}

