package com.bxm.messager.common.core.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.bxm.messager.common.model.base.BaseEntity;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 站内信息表
 * </p>
 *
 * @author pf.w
 * @since 2021-08-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("adsmedia_station_msg")
public class AdsmediaStationMsgEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 主题类型
     */
    private String subject;

    /**
     * 内容
     */
    private String context;

    /**
     * 发送人
     */
    private String sender;

    /**
     * 接收人ID, 为0 则是发送给所有人
     */
    private Long receiverId;

    /**
     * 发送时间
     */
    private Date sendDate;

    /**
     * 是否已查看
     */
    private Boolean hadReadFlag;

    /**
     * 删除； 1已删除， 0未删除
     */
    private Boolean deletedFlag;

    /**
     * 修改时间
     */
    private Date modifiedTime;


    public static final String ID = "id";

    public static final String SUBJECT = "subject";

    public static final String CONTEXT = "context";

    public static final String SENDER = "sender";

    public static final String RECEIVER_ID = "receiver_id";

    public static final String SEND_DATE = "send_date";

    public static final String HAD_READ_FLAG = "had_read_flag";

    public static final String DELETED_FLAG = "deleted_flag";

    public static final String MODIFIED_TIME = "modified_time";

}
