package com.bxm.messager.common.core.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.bxm.messager.common.model.base.BaseEntity;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 系统消息 与 用户 的是否已读关系表
 * </p>
 *
 * @author pf.w
 * @since 2021-08-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cat_station_sys_msg_status")
public class CatStationSysMsgStatusEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 信息ID
     */
    private Long msgId;

    /**
     * 接收人ID
     */
    private Long receiverId;

    /**
     * 是否已读
     */
    private Integer readFlag;

    /**
     * 查看时间
     */
    private Date readTime;

    /**
     * 是否逻辑删除：1 表示删除，0 表示未删除
     */
    private Integer deleted;

    /**
     * 删除时间
     */
    private Date deletedTime;


    public static final String ID = "id";

    public static final String MSG_ID = "msg_id";

    public static final String RECEIVER_ID = "receiver_id";

    public static final String READ_FLAG = "read_flag";

    public static final String READ_TIME = "read_time";

    public static final String DELETED = "deleted";

    public static final String DELETED_TIME = "deleted_time";

}
