package com.bxm.messager.common.enums;

/**
 *
 * 推送类型
 * 0：活动
 * 1：处罚公示
 * 2：政策通知
 * 3：客情维护
 * 4：节日通知
 * 5: 系统通知
 *
 * （说明：推送类型有表存储 t_message_topic_info  类型和描述一一对应 ）
 *
 * @author pf.w
 * @date 2021/8/18 11:36
 **/
public enum MessagePushTopicTypeEnum {

    MESSAGE_PUSH_TOPIC_HUODONG(0,"活动"),

    MESSAGE_PUSH_TOPIC_CHUFA(1,"处罚公示"),

    MESSAGE_PUSH_TOPIC_ZHENGCE(2,"政策通知"),

    MESSAGE_PUSH_TOPIC_KEQING(3,"客情维护"),

    MESSAGE_PUSH_TOPIC_JIERI(4,"节日通知"),

    MESSAGE_PUSH_TOPIC_XITONG(5,"系统通知")
    ;

    private int code;

    private String desc;

    MessagePushTopicTypeEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
