package com.bxm.messager.common.helper.util;

import com.bxm.acl.facade.AclAuthInterceptor;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.messager.common.helper.enums.RoleEnum;
import com.bxm.warcar.utils.IpHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/10 15:46
 */
@Slf4j
public final class UserRoleUtil {
    /**
     * 获取用户信息<br/>
     */
    public static UserVo getUser(HttpServletRequest request) {
        UserVo userVo = new UserVo();
        userVo.setUsername("admin");
        try {
            UserVo user = (UserVo) request.getAttribute(AclAuthInterceptor.USER_KEY);
            if (user == null) {
                return userVo;
            }
            user.setIp(IpHelper.getIpFromHeader(request));
            return user;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        return userVo;
    }

    public static UserVo getUser() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        return getUser(requestAttributes.getRequest());
    }

    /**
     * 判断 媒介
     */
    public static boolean isMj(UserVo user) {
        if (checkUserRoleIsNull(user)) {
            return false;
        }

        return !isLeader(user) && user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode());
    }

    /**
     * 判断 bd
     */
    public static boolean isBd(UserVo user) {
        if (checkUserRoleIsNull(user)) {
            return false;
        }

        return !isLeader(user) && user.getRoleCodes().contains(RoleEnum.BD.getCode());
    }

    private static boolean checkUserRoleIsNull(UserVo user) {
        if (user == null) {
            return true;
        }
        return CollectionUtils.isEmpty(user.getRoleCodes());
    }

    /**
     * 判断 ae
     */
    public static boolean isAe(UserVo user) {
        if (checkUserRoleIsNull(user)) {
            return false;
        }

        return !isLeader(user) && user.getRoleCodes().contains(RoleEnum.AE.getCode());
    }

    /**
     * 判断 sale
     */
    public static boolean isSale(UserVo user) {
        if (checkUserRoleIsNull(user)) {
            return false;
        }

        return !isLeader(user) && user.getRoleCodes().contains(RoleEnum.SALE.getCode());
    }

    /**
     * 判断leader
     */
    public static Boolean isLeader(UserVo user) {
        if (checkUserRoleIsNull(user)) {
            return false;
        }

        return user.getRoleCodes().contains(RoleEnum.BDLEADER.getCode())
                || user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode())
                || user.getRoleCodes().contains(RoleEnum.SALELEADER.getCode())
                || user.getRoleCodes().contains(RoleEnum.AELEADER.getCode());
    }

}
