package com.bxm.messager.common.integration.datapark;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.web.FacadeAssemblyDataService;
import com.bxm.datapark.web.FacadeSspActivityDataServive;
import com.bxm.datapark.web.FacadeSspCreativeDataServive;
import com.bxm.datapark.web.FacadeSspPositionDataServive;
import com.bxm.datapark.web.model.AssemblyData;
import com.bxm.datapark.web.model.AssemblyDataDTO;
import com.bxm.datapark.web.model.SspActivity;
import com.bxm.datapark.web.model.SspActivityData;
import com.bxm.datapark.web.model.SspActivityDataDTO;
import com.bxm.datapark.web.model.SspCreativeDaily;
import com.bxm.datapark.web.model.SspPositionFinanceDaily;
import com.bxm.warcar.utils.response.ResultModel;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/11 15:36
 */
@Slf4j
@EnableFeignClients("com.bxm.datapark.web")
@Configuration
public class DataparkWebIntegration {

    @Autowired
    private FacadeSspPositionDataServive facadeSspPositionDataServive;
    @Autowired
    private FacadeAssemblyDataService facadeAssemblyDataService;
    @Autowired
    private FacadeSspCreativeDataServive facadeSspCreativeDataServive;
    @Autowired
    private FacadeSspActivityDataServive facadeSspActivityDataServive;

    public List<SspPositionFinanceDaily> getPositionDspData( SspPositionFinanceDaily search){
        ResultModel<List<SspPositionFinanceDaily>> positionDspData = facadeSspPositionDataServive.getPositionDspData(search);
        if (positionDspData.isSuccessed()){
            return positionDspData.getReturnValue();
        }
        return Lists.newArrayList();
    }


    public Page<AssemblyData> getAssemblyData(AssemblyDataDTO search) {
        try {
            ResultModel<Page<AssemblyData>> resultModel = facadeAssemblyDataService.getAssemblyData(search);
            if (resultModel.isSuccessed()) {
                return resultModel.getReturnValue();
            }
            log.error("调用datapark getAssemblyData 服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        } catch (Exception e) {
            log.error("调用datapark getAssemblyData 服务异常！", e);
        }
        return new Page<>();
    }

    public List<SspActivity> getActivity(SspActivity search) {
        try {
            ResultModel<List<SspActivity>> resultModel = facadeSspActivityDataServive.getActivity(search);
            if (resultModel.isSuccessed()) {
                return resultModel.getReturnValue();
            }
            log.error("调用datapark getActivity 服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        } catch (Exception e) {
            log.error("调用datapark getActivity 服务异常！", e);
        }
        return Lists.newArrayList();
    }

    public List<SspActivityData> getActivityData(SspActivityDataDTO search) {
        try {
            ResultModel<List<SspActivityData>> resultModel = facadeSspActivityDataServive.getActivityData(search);
            if (resultModel.isSuccessed()) {
                return resultModel.getReturnValue();
            }
            log.error("调用datapark getActivityData 服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        } catch (Exception e) {
            log.error("调用datapark getActivityData 服务异常！", e);
        }
        return Lists.newArrayList();
    }

    public List<SspCreativeDaily> getCreativeData(SspCreativeDaily search) {
        try {
            ResultModel<List<SspCreativeDaily>> resultModel = facadeSspCreativeDataServive.getCreativeData(search);
            if (resultModel.isSuccessed()) {
                return resultModel.getReturnValue();
            }
            log.error("调用datapark getCreativeData 服务失败！-->{},{}", resultModel.getErrorCode(), resultModel.getErrorDesc());
        } catch (Exception e) {
            log.error("调用datapark getCreativeData 服务异常！", e);
        }
        return Lists.newArrayList();
    }
}
