package com.bxm.messager.common.model.dto;

import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
@Data
public class MessageListExportDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 搜索关键词
     */
    private String keywords;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /**
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 推送对象类型 0：媒体  1：广告主
     */
    private Integer pushGoalType;

    /**
     * 推送类型 0：活动  1：处罚公示 2：政策通知  3：客情维护  4：节日通知
     */
    private Integer pushTopicType;

    /**
     * 推送消息状态  0：待发送   1：已发送   2：撤回
     */
    private Integer pushStatus;
}
