package com.bxm.messager.common.model.vo;

import lombok.Data;

import java.util.Date;

/**
 *
 * 导出相关数据字段
 *
 * @author pf.w
 * @date 2021/8/18 11:05
 **/
@Data
public class MessageExportVO {

    /**
     * id
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 1:正文  0：模板
     */
    private Integer type;

    /**
     * 推送类型描述（名称）
     */
    private String pushTopicDesc;

    /**
     * 收件人类型描述 媒体 | 广告主
     */
    private String pushGoalDesc;

    /**
     * 推送对象收件人类型   0：全员  1：指定用户
     */
    private Integer pushGoalUserType;

    /**
     * 推送收件人指定用户  ","逗号隔开
     */
    private String pushGoalUserContent;

    /**
     * 推送消息状态  0：待发送   1：已发送   2：撤回
     */
    private Integer pushStatus;

    /**
     * 记录状态  0：已删除   1：可用
     */
    private Integer deleted;

    /**
     * 推送时间
     */
    private Date pushDataTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 修改人
     */
    private String updateUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;
}
