package com.bxm.messager.common.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 *
 * 消息列表数据实体
 *
 * @author pf.w
 * @date 2021/8/17 17:32
 **/
@Data
public class MessageListInfoVO implements Serializable {

    private static final long serialVersionUID = -8495050483336100143L;

    @Excel(name = "消息ID")
    private Long id;

    /**
     * 标题
     */
    @Excel(name = "标题")
    private String title;

    /**
     * 推送对象类型 0：媒体  1：广告主
     */
    private Integer pushGoalType;

    /**
     * 推送对象描述  媒体 | 广告主
     */
    @Excel(name = "推送对象")
    private String pushGoalDesc;

    /**
     * 推送类型 0：活动  1：处罚公示 2：政策通知  3：客情维护  4：节日通知
     */
    private Integer pushTopicType;

    /**
     * 推送类型描述（名称）
     */
    @Excel(name = "推送类型")
    private String pushTopicDesc;

    /**
     * 推送消息状态  0：待发送   1：已发送   2：撤回
     */
    private Integer pushStatus;

    @Excel(name = "推送状态")
    private String pushStatusDesc;
    /**
     * 推送时间
     */
    @Excel(name = "推送时间",format="yyyy-MM-dd HH:mm:ss")
    private Date pushDataTime;
}
