package com.bxm.messager.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.messager.common.model.dto.MessageDetailInfoDTO;
import com.bxm.messager.common.model.dto.MessageListExportDTO;
import com.bxm.messager.common.model.dto.MessageListInfoDTO;
import com.bxm.messager.common.model.vo.MessageDetailInfoVO;
import com.bxm.messager.common.model.vo.MessageListInfoVO;
import com.bxm.messager.common.model.vo.MessageTopicListInfoVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author pf.w
 * @date 2021/8/18 15:16
 **/
public interface MessageService {

    /**
     * 获取消息中心消息列表
     *
     * @param param 多条件组合查询参数
     * @return 消息中心列表集合
     */
    IPage<MessageListInfoVO> getMessageList(MessageListInfoDTO param);

    /**
     * 新增
     *
     * @param param 消息数据
     * @return true 成功
     */
    Boolean addMessage(MessageDetailInfoDTO param);

    /**
     * 编辑
     *
     * @param param 消息实体
     * @return true 成功
     */
    Boolean editMessage( MessageDetailInfoDTO param);

    /**
     * 详情
     *
     * @param messageId 消息id
     * @return
     */
    MessageDetailInfoVO getMessageInfo(Long messageId);

    /**
     * 消息操作接口
     *
     * @param messageId 消息id
     * @param operateType 0：删除   1：撤回
     * @return True : 成功
     */
    Boolean messageOperate(Long messageId,Integer operateType);

    /**
     * 导出信息
     * @param response
     */
    void messageListExport(MessageListExportDTO param, HttpServletResponse response);

    /**
     * 获取消息主题信息列表
     *
     * @return
     */
    List<MessageTopicListInfoVO> getMessageTopicInfo();

    /**
     * 两分钟更改下状态
     */
     Boolean updateMessagePushStatusTimes();

}
