package com.bxm.messager.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.messager.common.core.entity.*;
import com.bxm.messager.common.core.service.*;
import com.bxm.messager.common.service.SyncMessageSevice;
import com.bxm.messager.common.util.DateUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

@Service
@Slf4j
@AllArgsConstructor
public class SyncMessageServiceImpl implements SyncMessageSevice {

    private final AdsmediaStationMsgService adsmediaStationMsgService;

    private final AdsmediaStationSysMsgStatusService adsmediaStationSysMsgStatusService;

    private final CatStationMsgService catStationMsgService;

    private final CatStationSysMsgStatusService catStationSysMsgStatusService;

    private final MessageInfoService messageInfoService;

    private final MessageReadInfoService messageReadInfoService;


    @Override
    public Boolean syncAdsMediaMessage() {

        List<AdsmediaStationMsgEntity> asmeList = adsmediaStationMsgService.list();

        if(!CollectionUtils.isEmpty(asmeList)){
            for (AdsmediaStationMsgEntity adsEntity : asmeList) {

                MessageInfoEntity entity = new MessageInfoEntity();
                entity.setTitle(Objects.isNull(adsEntity.getSubject()) ? null : adsEntity.getSubject());
                entity.setType(1);
                entity.setPushTopicType(5);
                entity.setPushGoalType(0);
                entity.setPushGoalDesc("媒体");
                entity.setPushGoalUserType(adsEntity.getReceiverId()==0 ? 0 : 1);
                if(adsEntity.getReceiverId()!=0){
                    entity.setPushGoalUserContent(adsEntity.getReceiverId().toString());
                }
                entity.setPushContent(Objects.isNull(adsEntity.getContext()) ? null : adsEntity.getContext());
                entity.setDeleted(adsEntity.getDeletedFlag() ? 1 : 0);

                entity.setPushStatus(DateUtil.before(adsEntity.getSendDate()) ? 1 : 0);
                entity.setPushDataTime(adsEntity.getSendDate());
                entity.setCreateUser("adsmedia");

                messageInfoService.save(entity);

                log.info("=====导入消息id : {}，完成",entity.getId());

                if(adsEntity.getReceiverId()==0){
                    LambdaQueryWrapper<AdsmediaStationSysMsgStatusEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
                    //lambdaQueryWrapper.eq(AdsmediaStationSysMsgStatusEntity::getReceiverId,adsEntity.getReceiverId());
                    lambdaQueryWrapper.eq(AdsmediaStationSysMsgStatusEntity::getMsgId,adsEntity.getId());

                    List<AdsmediaStationSysMsgStatusEntity> statusList = adsmediaStationSysMsgStatusService.list(lambdaQueryWrapper);
                    if(!CollectionUtils.isEmpty(statusList)){
                        for (AdsmediaStationSysMsgStatusEntity adsStatusEntity : statusList) {
                            if(!adsStatusEntity.getReadFlag()){
                                continue;
                            }
                            MessageReadInfoEntity readInfoEntity = new MessageReadInfoEntity();
                            readInfoEntity.setGoalType(0);
                            readInfoEntity.setMessageId(entity.getId());
                            readInfoEntity.setGoalUserId(adsStatusEntity.getReceiverId());
                            readInfoEntity.setReadFlag(adsStatusEntity.getReadFlag() ? 1 : 0);
                            readInfoEntity.setReadTime(adsStatusEntity.getReadTime());
                            readInfoEntity.setDeleted(adsStatusEntity.getDeletedFlag() ? 1 : 0);
                            readInfoEntity.setDeletedTime(Objects.isNull(adsStatusEntity.getDeletedTime()) ? null : adsStatusEntity.getDeletedTime());

                            messageReadInfoService.save(readInfoEntity);

                            log.info("----导入已读消息id:{}，完成",readInfoEntity.getId());
                        }
                    }

                }else{
                    MessageReadInfoEntity readInfoEntity = new MessageReadInfoEntity();
                    readInfoEntity.setGoalType(0);
                    readInfoEntity.setMessageId(entity.getId());
                    readInfoEntity.setGoalUserId(adsEntity.getReceiverId());
                    readInfoEntity.setReadFlag(adsEntity.getHadReadFlag() ? 1 : 0);
                    readInfoEntity.setDeleted(adsEntity.getDeletedFlag() ? 1 : 0);

                    messageReadInfoService.save(readInfoEntity);

                    log.info("----导入已读消息id:{}，完成",readInfoEntity.getId());
                }
            }
        }

        return true;
    }

    @Override
    public Boolean syncCatMessage() {
        List<CatStationMsgEntity> catMsgList = catStationMsgService.list();

        if(!CollectionUtils.isEmpty(catMsgList)){
            for (CatStationMsgEntity catEntity : catMsgList) {

                MessageInfoEntity entity = new MessageInfoEntity();
                entity.setTitle(Objects.isNull(catEntity.getSubject()) ? null : catEntity.getSubject());
                entity.setType(1);
                entity.setPushTopicType(5);
                entity.setPushGoalType(0);
                entity.setPushGoalDesc("媒体");
                entity.setPushGoalUserType(catEntity.getReceiverId()==0 ? 0 : 1);
                if(catEntity.getReceiverId()!=0){
                    entity.setPushGoalUserContent(catEntity.getReceiverId().toString());
                }
                entity.setPushContent(Objects.isNull(catEntity.getContext()) ? null : catEntity.getContext());
                entity.setDeleted(catEntity.getDeleted());

                entity.setPushStatus(DateUtil.before(catEntity.getSendDate()) ? 1 : 0);
                entity.setPushDataTime(catEntity.getSendDate());
                entity.setCreateUser("mcssp");

                messageInfoService.save(entity);

                log.info("=====导入消息id : {}，完成",entity.getId());

                if(catEntity.getReceiverId()==0){
                    LambdaQueryWrapper<CatStationSysMsgStatusEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
                    //lambdaQueryWrapper.eq(AdsmediaStationSysMsgStatusEntity::getReceiverId,adsEntity.getReceiverId());
                    lambdaQueryWrapper.eq(CatStationSysMsgStatusEntity::getMsgId,catEntity.getId());

                    List<CatStationSysMsgStatusEntity> statusList = catStationSysMsgStatusService.list(lambdaQueryWrapper);
                    if(!CollectionUtils.isEmpty(statusList)){
                        for (CatStationSysMsgStatusEntity catStatusEntity : statusList) {
                            if(catStatusEntity.getReadFlag() != 1){
                                continue;
                            }
                            MessageReadInfoEntity readInfoEntity = new MessageReadInfoEntity();
                            readInfoEntity.setGoalType(0);
                            readInfoEntity.setMessageId(entity.getId());
                            readInfoEntity.setGoalUserId(catStatusEntity.getReceiverId());
                            readInfoEntity.setReadFlag(catStatusEntity.getReadFlag());
                            readInfoEntity.setReadTime(catStatusEntity.getReadTime());
                            readInfoEntity.setDeleted(catStatusEntity.getDeleted());
                            readInfoEntity.setDeletedTime(Objects.isNull(catStatusEntity.getDeletedTime()) ? null : catStatusEntity.getDeletedTime());

                            messageReadInfoService.save(readInfoEntity);

                            log.info("----导入已读消息id:{}，完成",readInfoEntity.getId());
                        }
                    }

                }else{
                    MessageReadInfoEntity readInfoEntity = new MessageReadInfoEntity();
                    readInfoEntity.setGoalType(0);
                    readInfoEntity.setMessageId(entity.getId());
                    readInfoEntity.setGoalUserId(catEntity.getReceiverId());
                    readInfoEntity.setReadFlag(catEntity.getHadReadFlag());
                    readInfoEntity.setDeleted(catEntity.getDeleted());

                    messageReadInfoService.save(readInfoEntity);

                    log.info("----导入已读消息id:{}，完成",readInfoEntity.getId());
                }
            }
        }
        return true;
    }
}
