package com.bxm.messager.common.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {

    public static Date getEndOfDay(Date date) {
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(date);
        calendarEnd.set(Calendar.HOUR_OF_DAY, 23);
        calendarEnd.set(Calendar.MINUTE, 59);
        calendarEnd.set(Calendar.SECOND, 59);

        //防止mysql自动加一秒,毫秒设为0
        calendarEnd.set(Calendar.MILLISECOND, 0);
       return calendarEnd.getTime();

    }

    // 获得某天最小时间 2018-03-20 00:00:00
    public static Date getStartOfDay(Date date) {

        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());

    }

    /**
     * 指定时间是否在当前时间之前
     *
     * @param when 时间点
     * @return true表示参数时间在当前时间之前
     */
    public static boolean before(Date when) {
        return after(new Date(), when);
    }

    /**
     * 指定时间是否在当前时间之后
     *
     * @param when 时间点
     * @return true表示参数时间在当前时间之后
     */
    public static boolean after(Date when) {
        return after(when, new Date());
    }

    /**
     * 比较两个日期，判断<code>source</code>是否在<code>target</code>之后
     *
     * @param source 源时间
     * @param target 比较的目标时间
     * @return true表示source在target之后，false反之
     */
    public static boolean after(Date source, Date target) {
        if (null == source || null == target) {
            return false;
        }
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(source);

        return source.after(target);
    }
}
