/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.messager.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.messager.common.core.entity.MessageInfoEntity;
import com.bxm.messager.common.core.mapper.MessageInfoMapper;
import com.bxm.messager.common.core.service.MessageInfoService;
import com.bxm.messager.common.core.service.MessagePushTopicInfoService;
import com.bxm.messager.common.enums.ChannelEnum;
import com.bxm.messager.common.enums.PushStatusEnum;
import com.bxm.messager.common.helper.util.UserRoleUtil;
import com.bxm.messager.common.model.dto.MessageDetailInfoDTO;
import com.bxm.messager.common.model.dto.MessageListExportDTO;
import com.bxm.messager.common.model.dto.MessageListInfoDTO;
import com.bxm.messager.common.model.vo.MessageDetailInfoVO;
import com.bxm.messager.common.model.vo.MessageListInfoVO;
import com.bxm.messager.common.model.vo.MessageTopicListInfoVO;
import com.bxm.messager.common.service.MessageService;
import com.bxm.messager.common.service.coverter.MessageCovert;
import com.bxm.messager.common.util.DateUtil;
import com.bxm.messager.common.util.ExcelUtil;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    private final MessagePushTopicInfoService messagePushTopicInfoService;
    private final MessageInfoService messageInfoService;
    private final MessageInfoMapper messageInfoMapper;

    @Override
    public IPage<MessageListInfoVO> getMessageList(MessageListInfoDTO param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        if (!Objects.isNull(param.getEndTime())) {
            param.setStartTime(DateUtil.getStartOfDay(param.getStartTime()));
            param.setEndTime(DateUtil.getEndOfDay(param.getEndTime()));
        }
        return this.messageInfoMapper.getMessageInfoList((Page<MessageListInfoVO>)page, param);
    }

    @Override
    public Boolean addMessage(MessageDetailInfoDTO param) {
        this.fillParam(param);
        return this.messageInfoService.save(param);
    }

    @Override
    public Boolean editMessage(MessageDetailInfoDTO param) {
        if (Objects.isNull(param.getId())) {
            return Boolean.FALSE;
        }
        this.fillParam(param);
        return this.messageInfoService.updateById(param);
    }

    private void fillParam(MessageDetailInfoDTO param) {
        String username = UserRoleUtil.getUser().getUsername();
        param.setUpdateUser(Objects.isNull(username) ? "\u9ed8\u8ba4" : username);
        param.setPushGoalDesc(param.getPushGoalType() == 0 ? ChannelEnum.CHANNEL_ENUM_MEITI.getDesc() : (param.getPushGoalType() == 1 ? ChannelEnum.CHANNEL_ENUM_GUANGGAO.getDesc() : "\u5176\u4ed6"));
    }

    @Override
    public MessageDetailInfoVO getMessageInfo(Long messageId) {
        return MessageCovert.INSTANCE.toMessageDetailInoVo((MessageInfoEntity)this.messageInfoService.getById(messageId));
    }

    @Override
    public Boolean messageOperate(Long messageId, Integer operateType) {
        boolean resultFlag;
        MessageInfoEntity entity = (MessageInfoEntity)this.messageInfoService.getById(messageId);
        if (Objects.isNull(entity)) {
            return false;
        }
        switch (operateType) {
            case 0: {
                entity.setDeleted(1);
                resultFlag = this.messageInfoService.updateById(entity);
                break;
            }
            case 1: {
                entity.setPushStatus(2);
                resultFlag = this.messageInfoService.updateById(entity);
                break;
            }
            default: {
                resultFlag = false;
            }
        }
        return resultFlag;
    }

    @Override
    public void messageListExport(MessageListExportDTO param, HttpServletResponse response) {
        List<MessageListInfoVO> list;
        if (!Objects.isNull(param.getEndTime())) {
            param.setStartTime(DateUtil.getStartOfDay(param.getStartTime()));
            param.setEndTime(DateUtil.getEndOfDay(param.getEndTime()));
        }
        if (CollectionUtils.isEmpty(list = this.messageInfoMapper.getMessageInfoListExport(param))) {
            return;
        }
        list.forEach(messageListInfoVO -> messageListInfoVO.setPushStatusDesc(messageListInfoVO.getPushStatus() == 0 ? PushStatusEnum.PUSH_STATUS_ENUM_NOW.getDesc() : (messageListInfoVO.getPushStatus() == 1 ? PushStatusEnum.PUSH_STATUS_ENUM_LATER.getDesc() : PushStatusEnum.PUSH_STATUS_ENUM_RECALL.getDesc())));
        ExcelUtil.exportExcel(list, null, "\u6d88\u606f\u62a5\u8868", MessageListInfoVO.class, "\u6d88\u606f\u62a5\u8868.xls", response);
    }

    @Override
    public List<MessageTopicListInfoVO> getMessageTopicInfo() {
        List topicListDb = this.messagePushTopicInfoService.list();
        if (CollectionUtils.isEmpty((Collection)topicListDb)) {
            return Lists.newArrayList();
        }
        return topicListDb.stream().map(MessageCovert.INSTANCE::toTopicListInfoVo).collect(Collectors.toList());
    }

    @Override
    public Boolean updateMessagePushStatusTimes() {
        this.messageInfoMapper.updatePushStatus();
        return Boolean.TRUE;
    }

    public MessageServiceImpl(MessagePushTopicInfoService messagePushTopicInfoService, MessageInfoService messageInfoService, MessageInfoMapper messageInfoMapper) {
        this.messagePushTopicInfoService = messagePushTopicInfoService;
        this.messageInfoService = messageInfoService;
        this.messageInfoMapper = messageInfoMapper;
    }
}

