package com.bxm.messager.controller.message;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.messager.common.helper.exception.BusinessException;
import com.bxm.messager.common.helper.exception.McCmsException;
import com.bxm.messager.common.model.dto.MessageDetailInfoDTO;
import com.bxm.messager.common.model.dto.MessageListExportDTO;
import com.bxm.messager.common.model.dto.MessageListInfoDTO;
import com.bxm.messager.common.model.vo.MessageDetailInfoVO;
import com.bxm.messager.common.model.vo.MessageListInfoVO;
import com.bxm.messager.common.model.vo.MessageTopicListInfoVO;
import com.bxm.messager.common.service.MessageService;
import com.bxm.warcar.file.autoconfigure.HttpFileConfiguration;
import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.HttpFileRequest;
import lombok.AllArgsConstructor;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @author pf.w
 * @date 2021/8/17 17:17
 **/
@RestController
@RequestMapping("/message")
@AllArgsConstructor
public class MessageController {

    private final MessageService messageService;

    private final HttpFileConfiguration httpFileConfiguration;

    private final  HttpFileManager httpFileManager;


    @InitBinder
    public void initBinder(WebDataBinder binder, WebRequest request) {
        DateFormat dateFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        binder.registerCustomEditor(Date.class, new CustomDateEditor(dateFormat, true));// CustomDateEditor为自定义日期编辑器
    }

    /**
     *
     * 获取消息列表
     *
     * @param param 入参
     * @return 分页集合
     */
    @RequestMapping("getMessageInfoList")
    public ResponseEntity<IPage<MessageListInfoVO>> getMessageList(MessageListInfoDTO param){
        return ResponseEntity.ok(messageService.getMessageList(param));
    }

    /**
     * 新增
     * @param param
     * @return
     */
    @PostMapping("addMessage")
    public ResponseEntity<Boolean> addMessage(@RequestBody MessageDetailInfoDTO param){
        return ResponseEntity.ok(messageService.addMessage(param));
    }

    /**
     * 编辑
     * @param param
     * @return
     */
    @PostMapping("editMessage")
    public ResponseEntity<Boolean> editMessage(@RequestBody MessageDetailInfoDTO param){
        return ResponseEntity.ok(messageService.editMessage(param));
    }

    /**
     * 获取详情
     *
     * @param messageId 消息ID
     * @return 详情实体
     */
    @RequestMapping("getMessageDetail")
    public ResponseEntity<MessageDetailInfoVO> getMessageInfo(Long messageId){
        return ResponseEntity.ok(messageService.getMessageInfo(messageId));
    }

    /**
     * 消息 操作接口
     * @param messageId 消息ID
     * @param operateType 操作类型   0：删除   1：撤回
     * @return
     */
    @PostMapping("messageOperate")
    public ResponseEntity<Boolean> messageOperate(Long messageId,Integer operateType){
        return ResponseEntity.ok(messageService.messageOperate(messageId,operateType));
    }

    /**
     * 导出 消息报表
     * @param response
     */
    @GetMapping("messageListExport")
    public void messageListExport(MessageListExportDTO param, HttpServletResponse response){
        messageService.messageListExport(param,response);
    }

    /**
     * 获取消息类型主题
     *
     * @return
     */
    @GetMapping("getMessageTopicInfo")
    public ResponseEntity<List<MessageTopicListInfoVO>> getMessageTopicInfo(){
        return ResponseEntity.ok(messageService.getMessageTopicInfo());
    }

    /**
     * 文件上传
     * @param file
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/upload")
    public ResponseEntity uploadImg(@RequestParam("file") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new McCmsException("上传文件不能为空！");
        }
        if(file.getSize() > httpFileConfiguration.getLimitSize()){
            throw new BusinessException("上传文件大小不能超过"+ httpFileConfiguration.getLimitSize()/(1024*1024.0) +"M！");
        }
        return ResponseEntity.ok(httpFileManager.upload(new HttpFileRequest(file)));
    }
}
