/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.messager.interceptor;

import com.bxm.acl.facade.AclAuthInterceptor;
import com.bxm.messager.common.helper.autoconfigure.config.ApplicationGlobalConfig;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;

/**
 * <h3>权限拦截</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/15 18:13
 */
@Configuration
@Component
public class InterceptorConfigurer implements WebMvcConfigurer {

    @Autowired
    private ApplicationGlobalConfig configuration;

    /**
     * 过滤的路径
     */
    private static final List<String> EXCLUDE_PATH_SET = Lists.newArrayList(
            //公共接口过滤
            "/common/**",
            "/times/**",
           /* "/message/**",*/
            // facade接口全过滤
            "/facade/**"

    );

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        // 多个拦截器组成一个拦截器链
        // addPathPatterns 用于添加拦截规则
        registry.addInterceptor(aclAuthInterceptor())
                .addPathPatterns("/*/**")
                //给检测系统提供修改券状态的接口，不加权限
                .excludePathPatterns(EXCLUDE_PATH_SET);
    }

    @Bean
    public AclAuthInterceptor aclAuthInterceptor() {
        return new AclAuthInterceptor(configuration.getAclSystemId());
    }
}
