/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.validate.internal;

import com.bxm.warcar.validate.AbstractValidator;
import com.bxm.warcar.validate.ConstraintViolationException;
import java.lang.reflect.Field;
import org.apache.commons.lang.math.NumberUtils;

public class NumericValidator
extends AbstractValidator {
    private static final long DEFAULT_MIN = Long.MIN_VALUE;
    private static final long DEFAULT_MAX = Long.MAX_VALUE;
    private final long min;
    private final long max;

    public NumericValidator(Field field) {
        this(field, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public NumericValidator(Field field, long min, long max) {
        super(field);
        if (min > max) {
            throw new IllegalArgumentException("min:" + min + " max:" + max);
        }
        this.min = min;
        this.max = max;
    }

    public NumericValidator(Field field, long min, long max, String value) {
        super(field, value);
        if (min > max) {
            throw new IllegalArgumentException("min:" + min + " max:" + max);
        }
        this.min = min;
        this.max = max;
    }

    @Override
    protected void doValidate(Object input) throws Exception {
        String v = String.valueOf(this.getValue(input));
        String defaultValue = this.getDefaultValue();
        if (!NumberUtils.isNumber((String)v)) {
            if (defaultValue != null) {
                this.setValue(input, defaultValue);
                return;
            }
            throw new ConstraintViolationException(this, v);
        }
        long lv = NumberUtils.toLong((String)v);
        if (lv < this.min || lv > this.max) {
            if (defaultValue != null) {
                this.setValue(input, defaultValue);
                return;
            }
            throw new ConstraintViolationException(this, v);
        }
    }

    @Override
    public String getConstraintDesc() {
        return this.getFieldDesc() + " must be numeric,value range:[" + this.min + "," + this.max + "]";
    }
}

