/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.connection.BsonWriterHelper;
import com.mongodb.connection.LevelCountingBsonWriter;
import java.util.List;
import org.bson.BsonBinaryWriter;
import org.bson.BsonElement;
import org.bson.BsonReader;
import org.bson.BsonWriter;

class ElementExtendingBsonWriter
extends LevelCountingBsonWriter {
    private final List<BsonElement> extraElements;

    ElementExtendingBsonWriter(BsonBinaryWriter writer, List<BsonElement> extraElements) {
        super(writer);
        this.extraElements = extraElements;
    }

    @Override
    public void writeEndDocument() {
        if (this.getCurrentLevel() == 0) {
            BsonWriterHelper.writeElements((BsonWriter)this.getBsonBinaryWriter(), this.extraElements);
        }
        super.writeEndDocument();
    }

    @Override
    public void pipe(BsonReader reader) {
        if (this.getCurrentLevel() == -1) {
            this.getBsonBinaryWriter().pipe(reader, this.extraElements);
        } else {
            this.getBsonBinaryWriter().pipe(reader);
        }
    }
}

