/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.messager.controller.base;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.messager.common.model.base.BaseEntity;
import com.bxm.messager.controller.base.HelperBaseController;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public abstract class WithoutAnnotationBaseController<T extends BaseEntity>
extends HelperBaseController {
    private static final Logger log = LoggerFactory.getLogger(WithoutAnnotationBaseController.class);

    protected abstract IService<T> getService();

    public ResponseEntity<T> post(T t) {
        if (this.getService().save(t)) {
            return ResponseEntity.ok(t);
        }
        return ResponseEntity.badRequest().build();
    }

    public ResponseEntity<T> put(T t) {
        if (this.getService().updateById(t)) {
            return ResponseEntity.ok(t);
        }
        return ResponseEntity.badRequest().build();
    }

    public ResponseEntity<Boolean> delete(Long id) {
        if (this.getService().removeById((Serializable)id)) {
            return ResponseEntity.ok((Object)true);
        }
        return ResponseEntity.badRequest().build();
    }

    protected ResponseEntity<Boolean> logicDelete(Long id) {
        IService<T> service = this.getService();
        BaseEntity t = (BaseEntity)service.getById((Serializable)id);
        if (null == t) {
            return ResponseEntity.ok((Object)false);
        }
        try {
            MethodUtils.invokeMethod((Object)t, (String)"setDeleted", (Object[])new Object[]{"yes"});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            log.error("logicDelete: ", (Throwable)ex);
            return ResponseEntity.badRequest().body((Object)false);
        }
        return ResponseEntity.ok((Object)service.updateById((Object)t));
    }

    public ResponseEntity<T> get(Long id) {
        return ResponseEntity.ok((Object)this.getService().getById((Serializable)id));
    }

    public ResponseEntity<List<T>> list(Page page, T query) {
        QueryWrapper wrappers = Wrappers.query(query);
        List orders = page.getOrders();
        if (CollectionUtils.isEmpty((Collection)orders)) {
            wrappers.orderByDesc((Object)"id");
        } else {
            orders.forEach(o -> {
                if (o.isAsc()) {
                    wrappers.orderByAsc((Object)o.getColumn());
                } else {
                    wrappers.orderByDesc((Object)o.getColumn());
                }
            });
        }
        return ResponseEntity.ok((Object)this.getService().list((Wrapper)Wrappers.query(query)));
    }

    public ResponseEntity<IPage<T>> page(Page<T> page, T query) {
        if (CollectionUtils.isEmpty((Collection)page.getOrders())) {
            page.setOrders((List)Lists.newArrayList((Object[])new OrderItem[]{OrderItem.desc((String)"id")}));
        }
        return ResponseEntity.ok((Object)this.getService().page(page, (Wrapper)Wrappers.query(query)));
    }
}

