/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.word.parse.excel;

import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.base.ExportCommonServer;
import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelExportEnum;
import cn.afterturn.easypoi.exception.word.WordExportException;
import cn.afterturn.easypoi.exception.word.enmus.WordExportEnum;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.word.entity.params.ExcelListEntity;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelEntityParse
extends ExportCommonServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelEntityParse.class);

    private static void checkExcelParams(ExcelListEntity entity) {
        if (entity.getList() == null || entity.getClazz() == null) {
            throw new WordExportException(WordExportEnum.EXCEL_PARAMS_ERROR);
        }
    }

    private int createCells(int index, Object t, List<ExcelExportEntity> excelParams, XWPFTable table, short rowHeight) {
        try {
            ExcelExportEntity entity;
            int k;
            XWPFTableRow row = table.insertNewTableRow(index);
            row.setHeight((int)rowHeight);
            int maxHeight = 1;
            int cellNum = 0;
            int paramSize = excelParams.size();
            for (k = 0; k < paramSize; ++k) {
                entity = excelParams.get(k);
                if (entity.getList() != null) {
                    Collection list = (Collection)entity.getMethod().invoke(t, new Object[0]);
                    int listC = 0;
                    for (Object obj : list) {
                        this.createListCells(index + listC, cellNum, obj, entity.getList(), table, rowHeight);
                        ++listC;
                    }
                    cellNum += entity.getList().size();
                    if (list == null || list.size() <= maxHeight) continue;
                    maxHeight = list.size();
                    continue;
                }
                Object value = this.getCellValue(entity, t);
                if (entity.getType() != 1) continue;
                this.setCellValue(row, value, cellNum++);
            }
            cellNum = 0;
            paramSize = excelParams.size();
            for (k = 0; k < paramSize; ++k) {
                entity = excelParams.get(k);
                if (entity.getList() != null) {
                    cellNum += entity.getList().size();
                    continue;
                }
                if (!entity.isNeedMerge() || maxHeight <= 1) continue;
                table.setCellMargins(index, index + maxHeight - 1, cellNum, cellNum);
                ++cellNum;
            }
            return maxHeight;
        }
        catch (Exception e) {
            LOGGER.error("excel cell export error ,data is :{}", (Object)ReflectionToStringBuilder.toString((Object)t));
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    public void createListCells(int index, int cellNum, Object obj, List<ExcelExportEntity> excelParams, XWPFTable table, short rowHeight) throws Exception {
        XWPFTableRow row;
        if (table.getRow(index) == null) {
            row = table.createRow();
            row.setHeight((int)rowHeight);
        } else {
            row = table.getRow(index);
        }
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            ExcelExportEntity entity = excelParams.get(k);
            Object value = this.getCellValue(entity, obj);
            if (entity.getType() != 1) continue;
            this.setCellValue(row, value, cellNum++);
        }
    }

    private Map<String, Integer> getTitleMap(XWPFTable table, int index, int headRows) {
        if (index < headRows) {
            throw new WordExportException(WordExportEnum.EXCEL_NO_HEAD);
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int j = 0; j < headRows; ++j) {
            List cells = table.getRow(index - j - 1).getTableCells();
            for (int i = 0; i < cells.size(); ++i) {
                String text = ((XWPFTableCell)cells.get(i)).getText();
                if (StringUtils.isEmpty((CharSequence)text)) {
                    throw new WordExportException(WordExportEnum.EXCEL_HEAD_HAVA_NULL);
                }
                map.put(text, i);
            }
        }
        return map;
    }

    public void parseNextRowAndAddRow(XWPFTable table, int index, ExcelListEntity entity) {
        table.removeRow(index);
        ExcelEntityParse.checkExcelParams(entity);
        Map<String, Integer> titlemap = this.getTitleMap(table, index, entity.getHeadRows());
        try {
            Field[] fileds = PoiPublicUtil.getClassFields(entity.getClazz());
            ExcelTarget etarget = entity.getClazz().getAnnotation(ExcelTarget.class);
            String targetId = null;
            if (etarget != null) {
                targetId = etarget.value();
            }
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            this.getAllExcelField(null, targetId, fileds, excelParams, entity.getClazz(), null, null);
            this.sortAndFilterExportField(excelParams, titlemap);
            short rowHeight = this.getRowHeight(excelParams);
            for (Object t : entity.getList()) {
                index += this.createCells(index, t, excelParams, table, rowHeight);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setCellValue(XWPFTableRow row, Object value, int cellNum) {
        if (row.getCell(cellNum++) != null) {
            row.getCell(cellNum - 1).setText(value == null ? "" : value.toString());
            PoiPublicUtil.setWordText(row.createCell().addParagraph().createRun(), value == null ? "" : value.toString());
        } else {
            PoiPublicUtil.setWordText(row.createCell().addParagraph().createRun(), value == null ? "" : value.toString());
        }
    }

    private void sortAndFilterExportField(List<ExcelExportEntity> excelParams, Map<String, Integer> titlemap) {
        for (int i = excelParams.size() - 1; i >= 0; --i) {
            if (excelParams.get(i).getList() != null && excelParams.get(i).getList().size() > 0) {
                this.sortAndFilterExportField(excelParams.get(i).getList(), titlemap);
                if (excelParams.get(i).getList().size() == 0) {
                    excelParams.remove(i);
                    continue;
                }
                excelParams.get(i).setOrderNum(i);
                continue;
            }
            if (titlemap.containsKey(excelParams.get(i).getName())) {
                excelParams.get(i).setOrderNum(i);
                continue;
            }
            excelParams.remove(i);
        }
        this.sortAllParams(excelParams);
    }
}

