/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.logging.autoconfigure;

import com.bxm.warcar.logging.LoggingWriter;
import com.bxm.warcar.logging.OncePerRequestLoggingFilter;
import com.bxm.warcar.logging.OperatorExtractor;
import com.bxm.warcar.logging.autoconfigure.LoggingProperties;
import java.util.Collection;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={LoggingProperties.class})
@ConditionalOnProperty(prefix="warcar.logging", name={"enable"}, havingValue="true")
public class LoggingAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingAutoConfiguration.class);
    private final LoggingProperties loggingProperties;

    public LoggingAutoConfiguration(LoggingProperties loggingProperties) {
        this.loggingProperties = loggingProperties;
    }

    @Bean
    public OncePerRequestLoggingFilter oncePerRequestLoggingFilter(ConfigurableEnvironment environment, ObjectProvider<List<LoggingWriter>> loggingWriterObjectProvider, ObjectProvider<OperatorExtractor> operatorExtractorObjectProvider) throws Throwable {
        OperatorExtractor operatorExtractor;
        String applicationId = this.getApplicationId(environment);
        List writers = (List)loggingWriterObjectProvider.getIfAvailable();
        LoggingWriter loggingWriter = null;
        Class<? extends LoggingWriter> writer = this.loggingProperties.getWriter();
        if (null != writer && CollectionUtils.isNotEmpty((Collection)writers)) {
            loggingWriter = writers.stream().filter(o -> ClassUtils.getUserClass((Object)o).equals(writer)).findAny().orElseThrow(() -> new NoSuchBeanDefinitionException(writer));
            LOGGER.info("Using {}", (Object)loggingWriter);
        }
        if (null == (operatorExtractor = (OperatorExtractor)operatorExtractorObjectProvider.getIfAvailable())) {
            LOGGER.warn("No OperatorExtractor implementor!");
        }
        int payloadByteMaxLength = this.loggingProperties.getPayloadByteMaxLength();
        OncePerRequestLoggingFilter loggingFilter = new OncePerRequestLoggingFilter(applicationId, payloadByteMaxLength, loggingWriter, operatorExtractor);
        loggingFilter.setExcludeRequestUriPrefix(this.loggingProperties.getExcludeRequestUriPrefix());
        return loggingFilter;
    }

    @Bean
    public FilterRegistrationBean<OncePerRequestLoggingFilter> oncePerRequestLoggingFilterFilterRegistrationBean(OncePerRequestLoggingFilter oncePerRequestLoggingFilter) {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)oncePerRequestLoggingFilter, new ServletRegistrationBean[0]);
        bean.setDispatcherTypes(this.loggingProperties.getDispatcherType(), new DispatcherType[0]);
        bean.addUrlPatterns(new String[]{this.loggingProperties.getUrlPatterns()});
        bean.setName(this.loggingProperties.getFilterName());
        bean.setOrder(Integer.MAX_VALUE);
        return bean;
    }

    private String getApplicationId(ConfigurableEnvironment environment) {
        String name = environment.getProperty("spring.application.name");
        return StringUtils.hasText((String)name) ? name : "application";
    }
}

