package com.bxm.dailyegg.deliver.model.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(description = "兑换订单列表信息")
public class ExchangeOrderItemDTO {

    @ApiModelProperty("收货人姓名")
    private String name;

    @ApiModelProperty("收货人联系方式")
    private String phone;

    @ApiModelProperty("收货人地址")
    private String deliverAddress;

    @ApiModelProperty(value = "[v1.4.0] 订单类型,1：20个鸡蛋（旧版本）,2：6个鸡蛋,3：10个鸡蛋,4：20个鸡蛋（新版本）")
    private Integer orderType;

    @ApiModelProperty("[v1.4.0] 订单标题")
    private String orderTitle;

    @ApiModelProperty("[v1.4.0] 订单图片")
    private String orderImgUrl;

    @ApiModelProperty("兑换时间,已格式化")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT)
    private Date exchangeTime;

    @ApiModelProperty(value = "发货状态,0:未发货,1：已发货")
    private Integer deliveryStatus;

    @ApiModelProperty(value = "支付状态,0：待支付,1：支付成功,2：支付失败")
    private Integer paymentStatus;

    @ApiModelProperty(value = "邮费")
    private BigDecimal postFeeAmount;

    @ApiModelProperty("物流公司名称")
    private String deliveryCompany;

    @ApiModelProperty("物流单号")
    private String deliveryOrderNo;
}
