package com.bxm.dailyegg.deliver.model.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author liujia
 * @since 2022-02-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_deliver_order")
@ApiModel(value = "DeliverOrderEntity对象", description = "")
public class DeliverOrderEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "所属用户")
    private Long userId;

    @ApiModelProperty(value = "收货人名称")
    private String name;

    @ApiModelProperty(value = "手机号码")
    private String phone;

    @ApiModelProperty(value = "收货地址（省市区）")
    private String address;

    @ApiModelProperty(value = "详细地址")
    private String detailAddress;

    @ApiModelProperty(value = "兑换时间")
    private Date exchangeTime;

    @ApiModelProperty(value = "发货状态")
    private Integer deliveryStatus;

    @ApiModelProperty(value = "物流公司名称")
    private String deliveryCompany;

    @ApiModelProperty(value = "物流订单号")
    private String deliveryOrderNo;

    @ApiModelProperty(value = "订单类型,1：20个鸡蛋（旧版本）,2：6个鸡蛋,3：10个鸡蛋,4：20个鸡蛋（新版本）")
    private Integer orderType;

    @ApiModelProperty(value = "支付时间")
    private Integer paymentStatus;

    @ApiModelProperty(value = "支付时间")
    private Date paymentTime;

    @ApiModelProperty(value = "支付备注")
    private String paymentRemark;

    @ApiModelProperty(value = "邮费金额")
    private BigDecimal postFeeAmount;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "变更时间")
    private Date modifyTime;

    @ApiModelProperty(value = "消耗鸡蛋数量")
    private Integer eggNum;
}
