package com.bxm.dailyegg.deliver.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(description = "鸡蛋可兑换订单选项")
@Data
public class ExchangeOrderChoiceItemDTO {

    @ApiModelProperty(value = "订单类型,1：20个鸡蛋（旧版本）,2：6个鸡蛋,3：10个鸡蛋,4：20个鸡蛋（新版本）")
    private String orderType;

    @ApiModelProperty("订单标题")
    private String orderTitle;

    @ApiModelProperty("兑换订单额外标签,eg: 差N枚可兑换")
    private String orderLabel;

    @ApiModelProperty("订单图片")
    private String orderImgUrl;

    @ApiModelProperty("是否仅限新用户")
    private Boolean newUserFlag;

    @ApiModelProperty("商品金额,实付金额都是0")
    private BigDecimal goodsPrice;

    @ApiModelProperty("运费")
    private BigDecimal freightCharge;

    @ApiModelProperty("应付金额")
    private BigDecimal finalAmount;

    @ApiModelProperty("用户当前可以兑换的鸡蛋数量")
    private Integer currentEggNum;

    @ApiModelProperty("兑换需要的鸡蛋数量")
    private Integer expectEggNum;
}
