package com.bxm.dailyegg.deliver.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(description = "兑换订单前置信息")
@Data
public class ExchangeOrderDetailDTO {

    @ApiModelProperty("订单ID")
    private Long orderId;

    @ApiModelProperty("收货人姓名")
    private String name;

    @ApiModelProperty("收货人联系方式")
    private String phone;

    @ApiModelProperty("收货人地址")
    private String deliverAddress;

    @ApiModelProperty(value = "订单类型,1：20个鸡蛋（旧版本）,2：6个鸡蛋,3：10个鸡蛋,4：20个鸡蛋（新版本）")
    private String orderType;

    @ApiModelProperty("订单标题")
    private String orderTitle;

    @ApiModelProperty("订单图片")
    private String orderImgUrl;

    @ApiModelProperty("商品金额")
    private BigDecimal goodsPrice;

    @ApiModelProperty("运费")
    private BigDecimal freightCharge;

    @ApiModelProperty("应付金额")
    private BigDecimal finalAmount;

    @ApiModelProperty("用户当前可以兑换的鸡蛋数量")
    private Integer currentEggNum;

    @ApiModelProperty("兑换需要的鸡蛋数量")
    private Integer expectEggNum;
}
