package com.bxm.dailyegg.deliver.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(description = "兑换订单管理列表项目")
public class ExchangeOrderManageItemDTO {

    @ApiModelProperty("兑换订单ID")
    private Long orderId;

    @ApiModelProperty("收货人名称")
    private String name;

    @ApiModelProperty("收货人手机号码")
    private String phone;

    @ApiModelProperty("完整的收货地址")
    private String fullAddress;

    @ApiModelProperty("兑换时间")
    private Date exchangeTime;

    @ApiModelProperty(value = "发货状态,0:未发货,1：已发货")
    private Integer deliveryStatus;

    @ApiModelProperty("物流公司名称")
    private String deliveryCompany;

    @ApiModelProperty("物流单号")
    private String deliveryOrderNo;

    @ApiModelProperty(value = "支付状态,0：待支付,1：支付成功,2：支付失败")
    private Integer paymentStatus;

    @ApiModelProperty(value = "邮费")
    private BigDecimal postFeeAmount;

    @ApiModelProperty(value = "订单类型,1：20个鸡蛋（旧版本）,2：6个鸡蛋,3：10个鸡蛋,4：20个鸡蛋（新版本）")
    private Integer orderType;

    @ApiModelProperty("用户id")
    private Long userId;
}
