package com.bxm.dailyegg.deliver.model.param;

import com.bxm.dailyegg.common.model.param.BaseUserParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "创建兑换订单参数")
@Data
public class CreateExchangeOrderParam extends BaseUserParam {

    @ApiModelProperty("收货人姓名")
    private String name;

    @ApiModelProperty("收货人联系方式")
    private String phone;

    @ApiModelProperty("收货人地址")
    private String address;

    @ApiModelProperty("收货人详细地址")
    private String detailAddress;

    @ApiModelProperty(value = "[v1.4.0]订单类型,1：20个鸡蛋（旧版本）,2：6个鸡蛋,3：10个鸡蛋,4：20个鸡蛋（新版本）")
    private String orderType;
}
