package com.bxm.dailyegg.task.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(description = "气泡任务项目信息")
public class BubbleTaskItemDTO {

    @ApiModelProperty("任务ID")
    private Long taskId;

    @ApiModelProperty("奖励粮食数量")
    private Integer awardGrainNum;

    @ApiModelProperty("任务触发行为,详见文档,包括激励视频（VIDEO）")
    private String action;

    /**
     * 如果缓存对象中存储的值发生了变化,则更新此值
     */
    public static final Integer CACHE_VERSION = 2;

    @ApiModelProperty(hidden = true)
    private Integer v = CACHE_VERSION;
}
