package com.bxm.dailyegg.task.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "任务列表项目详情")
@Data
public class TaskListItemDTO {

    @ApiModelProperty("任务标题")
    private String title;

    @ApiModelProperty("任务子标题")
    private String subTitle;

    @ApiModelProperty("当前任务奖励粮食数量")
    private Integer awardGrainNum;

    @ApiModelProperty("当前任务当前已做次数")
    private Integer currentTimes;

    @ApiModelProperty("当前任务最多可做次数")
    private Integer maxTimes;

    @ApiModelProperty("任务ID,回传时需要")
    private Long taskId;

    @ApiModelProperty("任务行为回调")
    private String action;

    @ApiModelProperty("当前任务是否完成,true表示已完成")
    private Boolean taskStatus;

    @ApiModelProperty("是否看视频 默认为true：看  false：不看")
    private Boolean lookVideo = Boolean.TRUE;

    /**
     * 如果缓存对象中存储的值发生了变化,则更新此值
     */
    public static final Integer CACHE_VERSION = 1;

    private Integer v = CACHE_VERSION;
}
