package com.bxm.dailyegg.task.model.dto;

import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "任务列表项目详情")
@Data
public class TaskListItemV2DTO implements Comparable<TaskListItemV2DTO> {

    @ApiModelProperty("任务标题")
    private String title;

    @ApiModelProperty("任务子标题")
    private String subTitle;

    @ApiModelProperty("当前任务奖励粮食数量")
    private Integer awardGrainNum;

    @ApiModelProperty("当前任务当前已做次数")
    private Integer currentTimes;

    @ApiModelProperty("当前任务最多可做次数")
    private Integer maxTimes;

    @ApiModelProperty("任务ID,回传时需要")
    private Long taskId;

    @ApiModelProperty("任务行为回调,回传时需要")
    private String action;

    @ApiModelProperty("任务是否已经完成,true表示已完成")
    private Boolean finish;

    @ApiModelProperty("任务点击后的行为,VIDEO:播放激励视频后回调、" +
        "PROTOCOL: 触发协议地址," +
        "RECEIVE: 领取任务奖励（调用14-03-03接口回调）," +
        "NONE：无行为（对应任务已经完成）")
    private String taskClickAction;

    @ApiModelProperty("taskClickAction为PROTOCOL时有值,如果为空则收起任务栏,回到首页")
    private String clickActionProtocol;

    @ApiModelProperty(hidden = true)
    private Integer order;

    @ApiModelProperty(hidden = true)
    private Boolean manual;

    public static TaskListItemV2DTO build(UserTaskItemBO cacheTaskItem) {
        TaskListItemV2DTO item = new TaskListItemV2DTO();
        item.setCurrentTimes(cacheTaskItem.getCurrent());
        item.setMaxTimes(cacheTaskItem.getMax());
        item.setFinish(cacheTaskItem.getFinish());
        item.setTaskId(cacheTaskItem.getTaskId());
        item.setAction(cacheTaskItem.getTaskAction());
        item.setManual(cacheTaskItem.getManual());
        item.setOrder(cacheTaskItem.getOrder());
        if (!cacheTaskItem.getFinish() && cacheTaskItem.getCurrent() >= cacheTaskItem.getMax()) {
            item.setTaskClickAction("RECEIVE");
        } else {
            item.setTaskClickAction("PROTOCOL");
        }
        return item;
    }

    @Override
    public int compareTo(TaskListItemV2DTO o) {
        return order - o.getOrder();
    }
}
