package com.bxm.datapark.facade.position.service;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.position.model.dto.PositionSpareTicketDto;
import com.bxm.datapark.facade.position.model.dto.PositionUserPortraitDto;
import com.bxm.datapark.facade.position.model.vo.PositionSpareTicketVo;
import com.bxm.datapark.facade.position.model.vo.PositionUserPortraitVo;
import com.bxm.util.dto.ResultModel;

/**
* @Title:PositionDataReportService.java
* @Package:com.bxm.datapark.facade.position.service
* @Description:广告位相关的统计报表接口 
 */
@FeignClient(name="datapark")
public interface PositionDataReportService {
     
    /**
    * @Title: analysisPositionSpareTicket  
    * @Description: 广告位备用券统计
    * @return ResultModel<Page<PositionSpareTicketVo>> 
     */
    @RequestMapping(value = "/position/spareTicket", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<PositionSpareTicketVo>> analysisPositionSpareTicket(@RequestBody PositionSpareTicketDto param);
    
    @RequestMapping(value = "/position/exportUserPortrait", method = RequestMethod.POST,consumes="application/json")
    ResultModel<List<PositionUserPortraitVo>> exportPositionUserPortrait(@RequestBody PositionUserPortraitDto param);
    
    @RequestMapping(value = "/position/userPortrait", method = RequestMethod.POST,consumes="application/json")
    ResultModel<Page<PositionUserPortraitVo>> analysisPositionUserPortrait(@RequestBody PositionUserPortraitDto param);
}
