package com.bxm.datapark.facade.adsmedia;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.adpopup.model.dto.PopupPositionDto;
import com.bxm.datapark.facade.adpopup.model.vo.*;
import com.bxm.datapark.facade.adsmedia.model.vo.AppCount;
import com.bxm.datapark.facade.ticket.model.dto.AppBusinessTicketDto;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 开发者pvuv数据
 *
 * @author lala
 * created on 2019/1/15
 */
@FeignClient(name = "datapark")
public interface AdsMediaReportService {
    /**
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param appKey
     * @param sortName  排序字段名称
     * @param sortType  排序方式
     * @return com.bxm.util.dto.ResultModel<java.util.List       <       com.bxm.datapark.model.mongo.vo.newad.AppCount>>
     * @description: 根据appKey  获取开发者所有广告位（子渠道）的数据，返回结果按子渠道维度
     * @author: JandMin
     * @time: 2018/7/5 15:37
     */
    @RequestMapping("/app/allBusiness/date")
    ResultModel<List<AppCount>> findAppAllBusinessCountByDate(@RequestParam("startTime") String startTime,
                                                              @RequestParam("endTime") String endTime,
                                                              @RequestParam("appKey") String appKey,
                                                              @RequestParam("sortName") String sortName,
                                                              @RequestParam("sortType") String sortType );

    /**
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param appKey
     * @param sortName  排序字段
     * @param sortType  排序方式
     * @return com.bxm.util.dto.ResultModel<java.util.List       <       com.bxm.datapark.model.mongo.vo.newad.AppCount>>
     * @description: 根据开发者appKey获取所有广告位的mid_page_pv和index_uv
     * @author: JandMin
     * @time: 2018/7/11 20:48
     */
    @RequestMapping("/app/uvpv/date")
    public ResultModel<List<AppCount>> findAppUvPvByDate(@RequestParam("startTime") String startTime,
                                                         @RequestParam("endTime") String endTime,
                                                         @RequestParam("appKey") String appKey,
                                                         @RequestParam("sortName") String sortName,
                                                         @RequestParam("sortType") String sortType);



}
