package com.bxm.datapark.facade.app.service;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.app.model.vo.ActivityCountVo;
import com.bxm.datapark.facade.app.model.vo.AppCountVo;
import com.bxm.datapark.facade.app.model.vo.TicketCountCommonVo;
import com.bxm.datapark.facade.ticket.model.dto.AppBusinessTicketDto;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import java.util.List;
import java.util.Map;

/**
 * 类说明：广告券日报相关报表服务
 * @author 作者： bcc
 * @version 创建时间：2018年7月24日 下午4:21:43
 */
@FeignClient(name="datapark")
public interface AppDataReportService {
    /**
     * 开发者日报
     * @param dto 查询参数对象
     * @return ResultModel<Page<AppCountVo>>
     */
    @RequestMapping(value = "/app/getAppCount", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<AppCountVo>> appReport(@RequestBody AppBusinessTicketDto dto);


    /**
     * 开发者日报导出
     * @param dto 查询参数对象
     * @return ResultModel<List<AppCountVo>>
     */
    @RequestMapping(value = "/app/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<AppCountVo>> appReportExport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 开发者日报-合计-按日
     * @param dto 查询参数对象
     * @return ResultModel<List<AppCountVo>>
     */
    @RequestMapping(value = "/app/getAppCountVosSum", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<AppCountVo>> appSumReport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 开发者日报-子链接
     * @param dto 查询参数对象
     * @return ResultModel<Page<AppCountVo>>
     */
    @RequestMapping(value = "/app/business", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<AppCountVo>> appBusinessReport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 开发者日报-子链接 导出报表
     * @param dto 查询参数对象
     * @return ResultModel<List<AppCountVo>>
     */
    @RequestMapping(value = "/app/business/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<AppCountVo>> appBusinessReportExport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 开发者日报-按日
     * @param dto 查询参数对象
     * @return ResultModel<List<AppCountVo>>
     */
    @RequestMapping(value = "/app/date", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<AppCountVo>> appDateReport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 开发者日报-广告券
     * @param dto 查询参数对象
     * @return ResultModel<Page<AppCountVo>>
     */
    @RequestMapping(value = "/app/ticket", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<TicketCountCommonVo>> appTicketReport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 开发者日报-广告券 导出
     * @param dto 查询参数对象
     * @return ResultModel<List<AppCountVo>>
     */
    @RequestMapping(value = "/app/ticket/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<TicketCountCommonVo>> appTicketReportExport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 开发者日报-子链接-按日
     * @param dto 查询参数对象
     * @return ResultModel<List<AppCountVo>>
     */
    @RequestMapping(value = "/app/business/date", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<AppCountVo>> appBusinessDateReport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 开发者日报-子链接-活动
     * @param dto 查询参数对象
     * @return ResultModel<Page<AppCountVo>>
     */
    @RequestMapping(value = "/app/business/activity", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<ActivityCountVo>> appBusinessActivity(@RequestBody AppBusinessTicketDto dto);

    /**
     * 开发者日报-子链接-活动 导出
     * @param dto 查询参数对象
     * @return ResultModel<List<AppCountVo>>
     */
    @RequestMapping(value = "/app/business/activity/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<ActivityCountVo>> appBusinessActivityExport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 开发者日报-广告券-按日
     * @param dto 查询参数对象
     * @return ResultModel<List<AppCountVo>>
     */
    @RequestMapping(value = "/app/ticket/date", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<TicketCountCommonVo>>  appTicketDateReport(@RequestBody AppBusinessTicketDto dto);
    
    /**
     * 查询时间范围内广告位上的统计数据
     * @param beginTime 开始时间
     * @param endTime 结束时间
     */
    @RequestMapping(value = "/app/business/profit/range/time",method = RequestMethod.POST, consumes="application/json")
    ResultModel<Map<String, Integer>> findAppBusinessProfitRangeTime(@RequestBody String json);
    
    /**
    * @Title: findTicketByRangeTime  
    * @Description: 查询具体某一天广告位下所有券的统计数据
    * @param datetime String
    * @return ResultModel<List<TicketCountCommonVo>> 
     */
    @RequestMapping(value = "/ticket/range/time",method = RequestMethod.POST,consumes="application/json")
    ResultModel<Map<String, String>> findTicketByRangeTime(@RequestBody String json);
    
    /**
     * 查询时间范围内广告位上的统计数据
     * @param datetime 开始时间
     * @param positionIds 广告位ID的集合
     */
    @RequestMapping(value = "/app/business/sum/profit",method = RequestMethod.POST,consumes="application/json")
    ResultModel<Map<String, Object>> findAppBusinessSumProfit(@RequestBody String json);
}
