package com.bxm.datapark.facade.ticket.model.dto;

import java.io.Serializable;
import java.util.List;

/**
 * 开发者日报报表
 */
public class AppBusinessTicketDto implements Serializable {

    private String datetime;

    private String startTime;

    private String endTime;

    private String appKey;

    private String business;

    private Long certificateid;

    /**
     * 是否首张弹券
     */
    private Integer scene;

    private String keyword;

    private Integer pageSize;

    private Integer pageNum;

    private String sortName;

    private String sortType;

    private String json;

    private String type;

    private Integer sHour;

    private Integer eHour;

    /**
     * 活动类型
     */
    private String activityType;
    /**
     * 活动策划
     */
    private String activityPlanner;
    
    /**
     *按日查询
     */
    private String byDate;

    /**
     * 券ID集合
     */
    private List<Long> certificateIds;

    public String getStartTime() {
        return startTime;
    }

    public void setStarttime(String starttime) {
        this.startTime = starttime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Long getCertificateid() {
        return certificateid;
    }

    public void setCertificateid(Long certificateid) {
        this.certificateid = certificateid;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public String getSortName() {
        return sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getJson() {
        return json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getsHour() {
        return sHour;
    }

    public void setsHour(Integer sHour) {
        this.sHour = sHour;
    }

    public Integer geteHour() {
        return eHour;
    }

    public void seteHour(Integer eHour) {
        this.eHour = eHour;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getActivityPlanner() {
        return activityPlanner;
    }

    public void setActivityPlanner(String activityPlanner) {
        this.activityPlanner = activityPlanner;
    }

    public String getByDate() {
        return byDate;
    }

    public void setByDate(String byDate) {
        this.byDate = byDate;
    }

    public List<Long> getCertificateIds() {
        return certificateIds;
    }

    public void setCertificateIds(List<Long> certificateIds) {
        this.certificateIds = certificateIds;
    }

    public AppBusinessTicketDto(){}

    public AppBusinessTicketDto(Builder builder){
        this.appKey = builder.appKey;
        this.business = builder.business;
        this.certificateid = builder.certificateid;
        this.datetime = builder.datetime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.scene = builder.scene;
        this.keyword = builder.keyword;
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
        this.sortName = builder.sortName;
        this.sortType = builder.sortType;
        this.json = builder.json;
        this.type = builder.type;
        this.sHour = builder.sHour;
        this.eHour = builder.eHour;
        this.activityType = builder.activityType;
        this.activityPlanner = builder.activityPlanner;
    }

    public static class Builder{
        private String datetime;
        private String startTime;
        private String endTime;
        private String appKey;
        private String business;
        private Long certificateid;
        private Integer scene;
        private String keyword;
        private Integer pageSize;
        private Integer pageNum;
        private String sortName;
        private String sortType;
        private String json;
        private String type;
        private Integer sHour;
        private Integer eHour;
        /**
         * 活动类型
         */
        private String activityType;
        /**
         * 活动策划
         */
        private String activityPlanner;
        public Builder datetime(String datetime){
            this.datetime = datetime;
            return this;
        }

        public Builder startTime(String startTime){
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(String endTime){
            this.endTime = endTime;
            return this;
        }

        public Builder appKey(String appKey){
            this.appKey = appKey;
            return this;
        }

        public Builder business(String business){
            this.business = business;
            return this;
        }

        public Builder certificateid(Long certificateid){
            this.certificateid = certificateid;
            return this;
        }

        public Builder scene(Integer scene){
            this.scene = scene;
            return this;
        }

        public Builder keyword(String keyword){
            this.keyword = keyword;
            return this;
        }

        public Builder pageSize(Integer pageSize){
            this.pageSize = pageSize;
            if(this.pageSize == null || this.pageSize<1){
                this.pageSize=10;
            }
            return this;
        }

        public Builder pageNum(Integer pageNum){
            this.pageNum = pageNum;
            if(this.pageNum == null || this.pageNum<1){
                this.pageNum = 1;
            }
            return this;
        }

        public Builder sortName(String sortName){
            this.sortName = sortName;
            return this;
        }

        public Builder sortType(String sortType){
            this.sortType = sortType;
            return this;
        }

        public Builder json(String json){
            this.json = json;
            return this;
        }

        public Builder type(String type){
            this.type = type;
            return this;
        }

        public Builder sHour(Integer sHour){
            this.sHour = sHour;
            return this;
        }

        public Builder eHour(Integer eHour){
            this.eHour = eHour;
            return this;
        }

        public AppBusinessTicketDto build(){
            return new AppBusinessTicketDto(this);
        }

        public Builder activityType(String activityType){
            this.activityType = activityType;
            return this;
        }

        public Builder activityPlanner(String activityPlanner){
            this.activityPlanner = activityPlanner;
            return this;
        }
    }
}
