package com.bxm.datapark.facade.ticket.model.dto;

import java.io.Serializable;
/**
* @Title:TicketExposureCount.java
* @Package:com.bxm.datapark.model.mongo.vo.newad
* @Description: 广告券落地页实体类
* @date:2018年8月8日 下午6:24:53
 */
public class TicketUrlDto implements Serializable{

    private static final long serialVersionUID = 6790337836409523714L;
    
    private String collectionName = "ad_certificate_exposure_today_stat";
    /**
     * 广告ID
     */
    private Long certificateId;
    
    /**
     * 排除查询的广告ID的集合
     */
    private String excludeCertificateIds;
     
    /**
     * 广告名称
     */
    private String shopsname;
    
    /**
     * 所属广告主
     */
    private String company;
    
    /**
     * AE
     */
    private String ae;
    
    /**
     * 点击量
     */
    private Double clickPv;
    
    /**
     * 落地页到达率
     */
    private Double exposureRate;
    
    /**
     * 落地页到达率(最大)
     */
    private Double exposureRateMax;
    
    /**
     * 落地页到达率(最小)
     */
    private Double exposureRateMin;
    
    /**
     * 页面号
     */
    private Integer pageNum = 1;
    
    /**
     * 页面大小
     */
    private Integer pageSize = 20;
    
    public String getCollectionName() {
        return collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public Long getCertificateId() {
        return certificateId;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public String getShopsname() {
        return shopsname;
    }

    public void setShopsname(String shopsname) {
        this.shopsname = shopsname;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getAe() {
        return ae;
    }

    public void setAe(String ae) {
        this.ae = ae;
    }

    public Double getClickPv() {
        return clickPv;
    }

    public void setClickPv(Double clickPv) {
        this.clickPv = clickPv;
    }

    public Double getExposureRate() {
        return exposureRate;
    }

    public void setExposureRate(Double exposureRate) {
        this.exposureRate = exposureRate;
    }

    public String getExcludeCertificateIds() {
        return excludeCertificateIds;
    }

    public void setExcludeCertificateIds(String excludeCertificateIds) {
        this.excludeCertificateIds = excludeCertificateIds;
    }

    public Double getExposureRateMax() {
        return exposureRateMax;
    }

    public void setExposureRateMax(Double exposureRateMax) {
        this.exposureRateMax = exposureRateMax;
    }

    public Double getExposureRateMin() {
        return exposureRateMin;
    }

    public void setExposureRateMin(Double exposureRateMin) {
        this.exposureRateMin = exposureRateMin;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
    
}
