package com.bxm.datapark.facade.activity;

import com.bxm.datapark.facade.Page;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * Created by wuwenquan on 2018/6/20.
 */
@FeignClient(name="datapark")
public interface ActivityRetentionService {
    /**
     * @param retentionReportDto
     * @return
     * @description 挽留表
     * @author 拉拉
     * @time 2019/3/22
     * @CopyRight 杭州微财科技有限公司
     */
    @RequestMapping(value ="/activity/getRetentionSummaryReport" ,method = RequestMethod.POST,  produces = "application/json")
    public ResultModel<Page<RetentionCountVo>> getRetentionSummaryReport(@RequestBody RetentionReportDto retentionReportDto) ;
    /**
     * @param retentionReportDto
     * @return
     * @description 挽留页子活动按日
     * @author 拉拉
     * @time 2019/3/22
     * @CopyRight 杭州微财科技有限公司
     */
    @RequestMapping(value ="/activity/getRetentionBySonActivityIdAndDate" ,method = RequestMethod.POST,  produces = "application/json")
    public ResultModel<List<RetentionCountVo>> getRetentionBySonActivityIdAndDate(@RequestBody RetentionReportDto retentionReportDto);


}
